/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft.strategy.oatoken.refresh;

import java.io.IOException;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.user.minecraft.oauth.OAuthApplication;
import ru.turikhay.tlauncher.user.minecraft.strategy.oatoken.MicrosoftOAuthToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.oatoken.refresh.MicrosoftOAuthTokenRefreshException;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.GsonParser;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.HttpClientRequester;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.InvalidResponseException;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.Parser;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.RequestAndParseStrategy;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.Requester;

public class MicrosoftOAuthTokenRefresher
extends RequestAndParseStrategy<MicrosoftOAuthToken, MicrosoftOAuthToken> {
    private static final Logger LOGGER = LogManager.getLogger(MicrosoftOAuthTokenRefresher.class);

    public MicrosoftOAuthTokenRefresher(String clientId) {
        this(new HttpClientRequester<MicrosoftOAuthToken>(token -> Request.Post((String)"https://login.live.com/oauth20_token.srf").bodyForm((Iterable)Form.form().add("client_id", clientId).add("refresh_token", token.getRefreshToken()).add("grant_type", "refresh_token").build())), GsonParser.lowerCaseWithUnderscores(MicrosoftOAuthToken.class));
    }

    public MicrosoftOAuthTokenRefresher(OAuthApplication application) {
        this(application.getClientId());
    }

    protected MicrosoftOAuthTokenRefresher(Requester<MicrosoftOAuthToken> requester, Parser<MicrosoftOAuthToken> parser) {
        super(LOGGER, requester, parser);
    }

    public MicrosoftOAuthToken refreshToken(MicrosoftOAuthToken token) throws MicrosoftOAuthTokenRefreshException, IOException {
        try {
            return (MicrosoftOAuthToken)this.requestAndParse(token);
        }
        catch (InvalidResponseException e) {
            throw new MicrosoftOAuthTokenRefreshException(e);
        }
    }
}

