/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft.strategy.oatoken;

import java.time.Instant;
import java.util.Objects;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.Validatable;

public class MicrosoftOAuthToken
implements Validatable {
    private String accessToken;
    private String refreshToken;
    private int expiresIn;
    private final transient Instant createdAt;

    public MicrosoftOAuthToken(String accessToken, String refreshToken, int expiresIn) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.createdAt = Instant.now();
        this.expiresIn = expiresIn;
    }

    public MicrosoftOAuthToken(String accessToken, String refreshToken, Instant expiresAt) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.createdAt = expiresAt.minusSeconds(3600L);
        this.expiresIn = 3600;
    }

    public MicrosoftOAuthToken() {
        this.createdAt = Instant.now();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MicrosoftOAuthToken that = (MicrosoftOAuthToken)o;
        if (this.expiresIn != that.expiresIn) {
            return false;
        }
        if (!Objects.equals(this.accessToken, that.accessToken)) {
            return false;
        }
        return Objects.equals(this.refreshToken, that.refreshToken);
    }

    public int hashCode() {
        int result = this.accessToken != null ? this.accessToken.hashCode() : 0;
        result = 31 * result + (this.refreshToken != null ? this.refreshToken.hashCode() : 0);
        result = 31 * result + this.expiresIn;
        return result;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Instant calculateExpiryTime() {
        return this.createdAt.plusSeconds(this.expiresIn);
    }

    public boolean isExpired() {
        return Instant.now().isAfter(this.calculateExpiryTime());
    }

    public String toString() {
        return "MicrosoftOAuthToken{accessToken='" + this.accessToken + '\'' + ", refreshToken='" + this.refreshToken + '\'' + ", expiresIn=" + this.expiresIn + ", createdAt=" + this.createdAt + '}';
    }

    @Override
    public void validate() {
        Validatable.notNull(this.accessToken, "accessToken");
        Validatable.notNull(this.refreshToken, "refreshToken");
        Validatable.notNegative(this.expiresIn, "refreshToken");
        Validatable.notNull(this.createdAt, "createdAt");
    }
}

