/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.nanohttpd;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthCodeRequestException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthExchangeCode;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.OAuthUrlParser;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.RedirectUrl;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.ILocalServer;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.LocalServerConfiguration;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.LocalServerException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.LocalServerSelectedConfiguration;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.LocalServerUrlProducer;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.nanohttpd.LockExchange;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.nanohttpd.NanoHttpdAdapter;
import ru.turikhay.util.U;
import ru.turikhay.util.async.AsyncThread;

public class NanoHttpdLocalServer
implements ILocalServer {
    private static final Logger LOGGER = LogManager.getLogger(NanoHttpdLocalServer.class);
    private final AtomicBoolean invoked = new AtomicBoolean(false);
    private final OAuthUrlParser urlParser;
    private final LocalServerUrlProducer urlProducer;
    private LockExchange lockExchange;
    private NanoHttpdAdapter adapter;
    LocalServerSelectedConfiguration selectedConfiguration;

    public NanoHttpdLocalServer(OAuthUrlParser urlParser, LocalServerUrlProducer urlProducer) {
        this.urlParser = urlParser;
        this.urlProducer = urlProducer;
    }

    @Override
    public LocalServerSelectedConfiguration start(LocalServerConfiguration configuration) throws LocalServerException {
        if (!this.invoked.compareAndSet(false, true)) {
            return this.selectedConfiguration;
        }
        LockExchange lockExchange = null;
        NanoHttpdAdapter adapter = null;
        ArrayList<IOException> serverStartExceptions = new ArrayList<IOException>();
        for (int port : configuration.getAllowedPorts()) {
            RedirectUrl redirectUrl;
            LOGGER.debug("Starting server on {}:{}", (Object)configuration.getHost(), (Object)port);
            this.selectedConfiguration = new LocalServerSelectedConfiguration(configuration.getHost(), port, configuration.getPath(), NanoHttpdLocalServer.generateState());
            try {
                redirectUrl = new RedirectUrl(this.urlProducer.buildRedirectUrl(this.selectedConfiguration));
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new LocalServerException("cannot build redirect uri", e);
            }
            lockExchange = new LockExchange();
            adapter = new NanoHttpdAdapter(this.selectedConfiguration, lockExchange, this.urlParser, redirectUrl, configuration.getRedirectOnSuccess());
            try {
                adapter.start();
                break;
            }
            catch (IOException e) {
                LOGGER.warn("Couldn't start local server on {}:{}", (Object)configuration.getHost(), (Object)port, (Object)e);
                serverStartExceptions.add(e);
                adapter = null;
            }
        }
        if (adapter == null) {
            LocalServerException e = new LocalServerException("every allowed port cannot be bound to");
            serverStartExceptions.forEach(e::addSuppressed);
            throw e;
        }
        this.adapter = adapter;
        this.lockExchange = lockExchange;
        return this.selectedConfiguration;
    }

    private static String generateState() {
        return String.valueOf(new Random().nextLong());
    }

    @Override
    public MicrosoftOAuthExchangeCode waitForCode(long time, TimeUnit timeUnit) throws MicrosoftOAuthCodeRequestException, TimeoutException, InterruptedException {
        if (!this.invoked.get()) {
            throw new IllegalStateException("server has not been started");
        }
        return this.lockExchange.waitForCode(time, timeUnit);
    }

    @Override
    public void stop() {
        if (!this.invoked.compareAndSet(true, false)) {
            throw new IllegalStateException("server has not been started");
        }
        AsyncThread.execute(() -> {
            U.sleepFor(2000L);
            this.adapter.stop();
        });
    }
}

