/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.nanohttpd;

import fi.iki.elonen.NanoHTTPD;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.exceptions.ParseException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.CodeRequestCancelledException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthCodeRequestException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthExchangeCode;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.OAuthUrlParser;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.RedirectUrl;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.LocalServerSelectedConfiguration;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.nanohttpd.LockExchange;

class NanoHttpdAdapter
extends NanoHTTPD {
    private static final Logger LOGGER = LogManager.getLogger(NanoHttpdAdapter.class);
    private final String expectedState;
    private final LockExchange lock;
    private final OAuthUrlParser urlParser;
    private final RedirectUrl redirectUrl;
    private final String successRedirectUrl;

    NanoHttpdAdapter(LocalServerSelectedConfiguration configuration, LockExchange lock, OAuthUrlParser urlParser, RedirectUrl redirectUrl, String successRedirectUrl) {
        super(configuration.getHost(), configuration.getPort());
        this.expectedState = configuration.getState();
        this.lock = lock;
        this.urlParser = urlParser;
        this.redirectUrl = redirectUrl;
        this.successRedirectUrl = successRedirectUrl;
    }

    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        String code;
        LOGGER.debug("New request: {}", (Object)session.getUri());
        if (!session.getMethod().equals((Object)NanoHTTPD.Method.GET)) {
            LOGGER.debug("Not a GET request");
            return this.badRequest();
        }
        if (session.getUri().equals(this.redirectUrl.getUrl().getPath())) {
            LOGGER.debug("Not redirect url");
            return this.badRequest();
        }
        if (this.expectedState != null) {
            if (!session.getParameters().containsKey("state")) {
                LOGGER.debug("No \"state\" parameter");
                return this.badRequest();
            }
            String state = (String)((List)session.getParameters().get("state")).get(0);
            if (!state.equals(this.expectedState)) {
                LOGGER.warn("Expected state: {}, but got: {}", (Object)this.expectedState, (Object)state);
                return this.badRequest();
            }
        }
        try {
            code = this.urlParser.parseAndValidate(session.getUri() + "?" + session.getQueryParameterString());
        }
        catch (ParseException e) {
            LOGGER.debug("Not valid request");
            return this.badRequest();
        }
        catch (CodeRequestCancelledException e) {
            LOGGER.info("Cancelled");
            return this.handleCancel(e);
        }
        catch (MicrosoftOAuthCodeRequestException e) {
            LOGGER.info("Returned an error");
            return this.handleError(e);
        }
        return this.handleCode(code);
    }

    private NanoHTTPD.Response handleError(MicrosoftOAuthCodeRequestException e) {
        this.lock.unlockWithError(e);
        return this.error();
    }

    private NanoHTTPD.Response handleCancel(CodeRequestCancelledException e) {
        this.lock.unlockWithError(e);
        return this.cancelled();
    }

    private NanoHTTPD.Response handleCode(String code) {
        this.lock.unlock(new MicrosoftOAuthExchangeCode(code, this.redirectUrl));
        return this.ok();
    }

    private NanoHTTPD.Response ok() {
        boolean redirect = this.successRedirectUrl != null;
        NanoHTTPD.Response response = NanoHttpdAdapter.newResponse((NanoHTTPD.Response.IStatus)(redirect ? NanoHTTPD.Response.Status.FOUND : NanoHTTPD.Response.Status.OK), "Success");
        if (redirect) {
            response.addHeader("Location", this.successRedirectUrl);
        }
        return response;
    }

    private NanoHTTPD.Response error() {
        return NanoHttpdAdapter.newResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, "Something went wrong");
    }

    private NanoHTTPD.Response cancelled() {
        return NanoHttpdAdapter.newResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, "Cancelled");
    }

    private NanoHTTPD.Response badRequest() {
        return NanoHttpdAdapter.newResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST, "Bad Request");
    }

    private static NanoHTTPD.Response newResponse(NanoHTTPD.Response.IStatus status, String text) {
        return NanoHttpdAdapter.newFixedLengthResponse((NanoHTTPD.Response.IStatus)status, (String)"text/plain", (String)text);
    }
}

