/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.nanohttpd;

import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthCodeRequestException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthExchangeCode;

class LockExchange {
    private final CountDownLatch lock = new CountDownLatch(1);
    private volatile MicrosoftOAuthExchangeCode code;
    private volatile MicrosoftOAuthCodeRequestException error;

    LockExchange() {
    }

    MicrosoftOAuthExchangeCode waitForCode(long time, TimeUnit timeUnit) throws MicrosoftOAuthCodeRequestException, InterruptedException, TimeoutException {
        if (!this.lock.await(time, timeUnit)) {
            throw new TimeoutException();
        }
        if (this.error == null) {
            return Objects.requireNonNull(this.code, "code");
        }
        throw this.error;
    }

    void unlock(MicrosoftOAuthExchangeCode code) {
        this.code = Objects.requireNonNull(code, "code");
        this.done();
    }

    void unlockWithError(MicrosoftOAuthCodeRequestException error) {
        this.error = Objects.requireNonNull(error, "error");
        this.done();
    }

    private void done() {
        this.lock.countDown();
    }
}

