/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthCodeRequestException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthCodeRequestStrategy;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthExchangeCode;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.ExternalBrowser;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.ILocalServer;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.LocalServerConfiguration;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.LocalServerException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.LocalServerSelectedConfiguration;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.lcserv.LocalServerUrlProducer;

public class LocalServerStrategy
implements MicrosoftOAuthCodeRequestStrategy {
    private static final Logger LOGGER = LogManager.getLogger(LocalServerStrategy.class);
    private final ExternalBrowser externalBrowser;
    private final LocalServerUrlProducer localServerUrlProducer;
    private final ILocalServer localServer;
    private final LocalServerConfiguration serverConfiguration;

    public LocalServerStrategy(ExternalBrowser externalBrowser, LocalServerUrlProducer localServerUrlProducer, ILocalServer localServer, LocalServerConfiguration serverConfiguration) {
        this.externalBrowser = externalBrowser;
        this.localServerUrlProducer = localServerUrlProducer;
        this.localServer = localServer;
        this.serverConfiguration = serverConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MicrosoftOAuthExchangeCode requestMicrosoftOAuthCode(long time, TimeUnit timeUnit) throws MicrosoftOAuthCodeRequestException, InterruptedException, TimeoutException {
        LOGGER.trace("Starting local server");
        LocalServerSelectedConfiguration selectedConfiguration = this.startServer();
        this.serverConfiguration.setSelectedConfiguration(selectedConfiguration);
        try {
            this.openExternalBrowser(selectedConfiguration);
            MicrosoftOAuthExchangeCode microsoftOAuthExchangeCode = this.waitForCode(time, timeUnit);
            return microsoftOAuthExchangeCode;
        }
        finally {
            this.localServer.stop();
        }
    }

    public LocalServerSelectedConfiguration startServer() throws MicrosoftOAuthCodeRequestException {
        try {
            return this.localServer.start(this.serverConfiguration);
        }
        catch (LocalServerException e) {
            throw new MicrosoftOAuthCodeRequestException("cannot start local server", e);
        }
    }

    private void openExternalBrowser(LocalServerSelectedConfiguration selectedConfiguration) throws MicrosoftOAuthCodeRequestException {
        String loginPageUrl;
        try {
            loginPageUrl = this.localServerUrlProducer.buildLoginUrl(selectedConfiguration);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new MicrosoftOAuthCodeRequestException("invalid login page url", e);
        }
        LOGGER.debug("Opening login page: {}", (Object)loginPageUrl);
        this.externalBrowser.openUrl(loginPageUrl);
    }

    private MicrosoftOAuthExchangeCode waitForCode(long time, TimeUnit timeUnit) throws MicrosoftOAuthCodeRequestException, InterruptedException, TimeoutException {
        return this.localServer.waitForCode(time, timeUnit);
    }
}

