/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft.strategy.oareq.embed;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.embed.BrowserConfiguration;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.embed.EmbeddedBrowser;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.embed.URLCallback;

public class JavaFXBrowser
implements EmbeddedBrowser {
    private static final int WIDTH = 600;
    private static final int HEIGHT = 600;
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    private final boolean explicitExit;
    private BrowserConfiguration configuration;
    private URLCallback urlCallback;
    private JFrame window;
    private JFXPanel panel;
    private WebView webView;

    public JavaFXBrowser(boolean explicitExit) {
        this.explicitExit = explicitExit;
    }

    public JavaFXBrowser() {
        this(false);
    }

    private void init(URL url) {
        this.initFrame();
        this.initJFX(url);
        this.packAndShow();
    }

    private void initFrame() {
        this.window = new JFrame();
        this.window.setTitle(this.configuration.getTitle());
        this.window.setIconImages(this.configuration.getFavicons());
        this.window.setResizable(false);
        this.window.setDefaultCloseOperation(2);
        this.window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JavaFXBrowser.this.destroy();
            }
        });
    }

    private void initJFX(URL url) {
        if (this.explicitExit) {
            Platform.setImplicitExit((boolean)false);
        }
        this.panel = new JFXPanel();
        this.panel.setPreferredSize(new Dimension(600, 600));
        Platform.runLater(() -> this.initWebView(url));
        this.window.setContentPane((Container)this.panel);
    }

    private void packAndShow() {
        this.window.pack();
        this.window.setLocationRelativeTo(null);
        this.window.setVisible(true);
    }

    private void initWebView(URL url) {
        if (this.configuration.isClearCookies()) {
            CookieHandler.setDefault(new CookieManager());
        }
        this.webView = new WebView();
        this.webView.setPrefSize(600.0, 600.0);
        this.webView.getEngine().load(url.toString());
        this.webView.getEngine().getHistory().getEntries().addListener(c -> {
            if (c.next() && c.wasAdded()) {
                for (WebHistory.Entry entry : c.getAddedSubList()) {
                    this.urlCallback.navigatedUrl(entry.getUrl());
                }
            }
        });
        Group group = new Group(new Node[]{this.webView});
        this.panel.setScene(new Scene((Parent)group));
    }

    private void destroy() {
        Platform.runLater(() -> {
            if (this.webView == null || this.panel == null) {
                return;
            }
            this.webView.getEngine().getLoadWorker().cancel();
            this.webView = null;
            this.panel.setScene(null);
            this.panel = null;
            SwingUtilities.invokeLater(() -> {
                if (this.window == null) {
                    return;
                }
                this.window.dispose();
                this.window = null;
            });
        });
        this.closeLatch.countDown();
    }

    @Override
    public void initAndShow(BrowserConfiguration configuration, URL url, URLCallback callback) {
        this.configuration = configuration;
        this.urlCallback = callback;
        SwingUtilities.invokeLater(() -> this.init(url));
    }

    @Override
    public void close() {
        this.destroy();
    }

    @Override
    public void waitForClose(long time, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        if (!this.closeLatch.await(time, timeUnit)) {
            throw new TimeoutException();
        }
    }

    public static void checkAvailable() {
        WebView.class.toString();
    }
}

