/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft.strategy.oareq.embed;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.exceptions.ParseException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.CodeRequestCancelledException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthCodeRequestException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthCodeRequestStrategy;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthExchangeCode;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.OAuthUrlParser;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.embed.BrowserConfiguration;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.embed.EmbeddedBrowser;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.embed.EmbeddedBrowserUrlProducer;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.embed.JavaFXBrowser;

public class EmbeddedBrowserStrategy
implements MicrosoftOAuthCodeRequestStrategy {
    private static final Logger LOGGER = LogManager.getLogger(EmbeddedBrowserStrategy.class);
    private final ExecutorService urlThread = Executors.newSingleThreadExecutor();
    private final EmbeddedBrowser browser;
    private final EmbeddedBrowserUrlProducer urlProducer;
    private final BrowserConfiguration configuration;
    private final OAuthUrlParser parser;
    private MicrosoftOAuthExchangeCode code;
    private MicrosoftOAuthCodeRequestException exception;

    public EmbeddedBrowserStrategy(EmbeddedBrowser browser, EmbeddedBrowserUrlProducer urlProducer, BrowserConfiguration configuration, OAuthUrlParser parser) {
        this.browser = browser;
        this.urlProducer = urlProducer;
        this.configuration = configuration;
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MicrosoftOAuthExchangeCode requestMicrosoftOAuthCode(long time, TimeUnit timeUnit) throws MicrosoftOAuthCodeRequestException, InterruptedException, TimeoutException {
        URL url;
        try {
            url = this.urlProducer.buildLoginUrl();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new MicrosoftOAuthCodeRequestException("bad initial uri syntax", e);
        }
        this.browser.initAndShow(this.configuration, url, this::deferUrlNavigated);
        try {
            this.browser.waitForClose(time, timeUnit);
        }
        finally {
            this.browser.close();
        }
        if (this.exception != null) {
            throw new MicrosoftOAuthCodeRequestException("url parsed an error", this.exception);
        }
        if (this.code == null) {
            throw new CodeRequestCancelledException("browser closed and no code received");
        }
        return this.code;
    }

    private void deferUrlNavigated(String url) {
        this.urlThread.submit(() -> this.urlNavigated(url));
    }

    private void urlNavigated(String url) {
        LOGGER.trace("Navigated: {}", (Object)url);
        String code = null;
        try {
            code = this.parser.parseAndValidate(url);
        }
        catch (ParseException e) {
            LOGGER.trace("Couldn't parse: {}", (Object)e.toString());
            return;
        }
        catch (MicrosoftOAuthCodeRequestException e) {
            LOGGER.warn("Parser returned: {}", (Object)e.toString());
            this.exception = e;
        }
        this.code = code == null ? null : new MicrosoftOAuthExchangeCode(code, this.urlProducer.getRedirectUrl());
        this.browser.close();
    }

    public static boolean isJavaFXWebViewSupported() {
        try {
            JavaFXBrowser.checkAvailable();
        }
        catch (Error e) {
            LOGGER.info("JavaFX Browser not available: {}", (Object)e.toString());
            return false;
        }
        return true;
    }
}

