/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft.strategy.oareq;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import ru.turikhay.tlauncher.exceptions.ParseException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.CodeRequestCancelledException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.CodeRequestErrorException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthCodeRequestException;

public class OAuthUrlParser {
    public String parseAndValidate(String url) throws MicrosoftOAuthCodeRequestException, ParseException {
        List pairs;
        try {
            pairs = URLEncodedUtils.parse((URI)new URI(url), (Charset)StandardCharsets.UTF_8);
        }
        catch (URISyntaxException e) {
            throw new ParseException(e);
        }
        String error = OAuthUrlParser.findByKey(pairs, "error");
        if (error != null) {
            if (error.equals("access_denied")) {
                throw new CodeRequestCancelledException("redirect page received \"access_denied\"");
            }
            throw new CodeRequestErrorException(error, OAuthUrlParser.findByKey(pairs, "error_description"));
        }
        Optional<NameValuePair> code = pairs.stream().filter(p -> p.getName().equals("code")).findAny();
        if (code.isPresent()) {
            return code.get().getValue();
        }
        throw new ParseException("no code in query");
    }

    private static String findByKey(List<NameValuePair> pairs, String key) {
        Optional<NameValuePair> pair = pairs.stream().filter(p -> p.getName().equals(key)).findAny();
        return pair.map(NameValuePair::getValue).orElse(null);
    }
}

