/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth;

import java.io.IOException;
import java.util.Locale;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth.MinecraftServicesAuthenticationException;
import ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth.MinecraftServicesToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.GsonParser;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.HttpClientRequester;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.InvalidResponseException;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.Parser;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.RequestAndParseStrategy;
import ru.turikhay.tlauncher.user.minecraft.strategy.rqnpr.Requester;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.XboxServiceAuthenticationResponse;

public class MinecraftServicesAuthenticator
extends RequestAndParseStrategy<XboxServiceAuthenticationResponse, MinecraftServicesToken> {
    private static final Logger LOGGER = LogManager.getLogger(MinecraftServicesAuthenticator.class);

    public MinecraftServicesAuthenticator() {
        this(new HttpClientRequester<XboxServiceAuthenticationResponse>(r -> Request.Post((String)"https://api.minecraftservices.com/authentication/login_with_xbox").bodyString(String.format(Locale.ROOT, "{\"identityToken\":\"XBL3.0 x=%s;%s\"}", r.getUHS(), r.getToken()), ContentType.APPLICATION_JSON)));
    }

    MinecraftServicesAuthenticator(Requester<XboxServiceAuthenticationResponse> requester) {
        this(requester, GsonParser.lowerCaseWithUnderscores(MinecraftServicesToken.class));
    }

    MinecraftServicesAuthenticator(Requester<XboxServiceAuthenticationResponse> requester, Parser<MinecraftServicesToken> parser) {
        super(LOGGER, requester, parser);
    }

    public MinecraftServicesToken minecraftServicesAuthenticate(XboxServiceAuthenticationResponse xstsResponse) throws MinecraftServicesAuthenticationException, IOException {
        try {
            return (MinecraftServicesToken)this.requestAndParse(xstsResponse);
        }
        catch (InvalidResponseException e) {
            throw new MinecraftServicesAuthenticationException(e);
        }
    }
}

