/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft;

import java.io.IOException;
import ru.turikhay.tlauncher.user.MinecraftUser;
import ru.turikhay.tlauncher.user.minecraft.strategy.MinecraftAuthenticationException;
import ru.turikhay.tlauncher.user.minecraft.strategy.gos.GameOwnershipValidator;
import ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth.MinecraftServicesAuthenticator;
import ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth.MinecraftServicesToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.oatoken.MicrosoftOAuthToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.oatoken.refresh.MicrosoftOAuthTokenRefresher;
import ru.turikhay.tlauncher.user.minecraft.strategy.pconv.MinecraftProfileConverter;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.MinecraftOAuthProfile;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.MinecraftProfileRequestException;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.MinecraftProfileRequester;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.XboxServiceAuthenticationResponse;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.auth.XboxLiveAuthenticator;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.xsts.XSTSAuthenticator;

public class MinecraftOAuthRefresh {
    private final MicrosoftOAuthTokenRefresher tokenRefresher;
    private final XboxLiveAuthenticator xboxLiveAuthenticator;
    private final XSTSAuthenticator xstsAuthenticator;
    private final MinecraftServicesAuthenticator minecraftServicesAuthenticator;
    private final GameOwnershipValidator gameOwnershipValidator;
    private final MinecraftProfileRequester minecraftProfileRequester;
    private final MinecraftProfileConverter minecraftProfileConverter;

    public MinecraftOAuthRefresh(MicrosoftOAuthTokenRefresher tokenRefresher, XboxLiveAuthenticator xboxLiveAuthenticator, XSTSAuthenticator xstsAuthenticator, MinecraftServicesAuthenticator minecraftServicesAuthenticator, GameOwnershipValidator gameOwnershipValidator, MinecraftProfileRequester minecraftProfileRequester, MinecraftProfileConverter minecraftProfileConverter) {
        this.tokenRefresher = tokenRefresher;
        this.xboxLiveAuthenticator = xboxLiveAuthenticator;
        this.xstsAuthenticator = xstsAuthenticator;
        this.minecraftServicesAuthenticator = minecraftServicesAuthenticator;
        this.gameOwnershipValidator = gameOwnershipValidator;
        this.minecraftProfileRequester = minecraftProfileRequester;
        this.minecraftProfileConverter = minecraftProfileConverter;
    }

    public MinecraftUser refreshIfNeeded(MicrosoftOAuthToken microsoftToken, MinecraftServicesToken minecraftToken) throws MinecraftAuthenticationException, IOException {
        MinecraftOAuthProfile profile;
        try {
            profile = this.minecraftProfileRequester.requestProfile(minecraftToken);
        }
        catch (MinecraftProfileRequestException e) {
            return this.refreshExplicitly(microsoftToken);
        }
        return this.minecraftProfileConverter.convertToMinecraftUser(microsoftToken, minecraftToken, profile);
    }

    public MinecraftUser refreshExplicitly(MicrosoftOAuthToken expiredToken) throws MinecraftAuthenticationException, IOException {
        MicrosoftOAuthToken token = this.tokenRefresher.refreshToken(expiredToken);
        XboxServiceAuthenticationResponse xlToken = this.xboxLiveAuthenticator.xboxLiveAuthenticate(token);
        XboxServiceAuthenticationResponse xstsToken = this.xstsAuthenticator.xstsAuthenticate(xlToken.getToken());
        MinecraftServicesToken mcsToken = this.minecraftServicesAuthenticator.minecraftServicesAuthenticate(xstsToken);
        this.gameOwnershipValidator.checkGameOwnership(mcsToken);
        MinecraftOAuthProfile profile = this.minecraftProfileRequester.requestProfile(mcsToken);
        return this.minecraftProfileConverter.convertToMinecraftUser(token, mcsToken, profile);
    }
}

