/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user.minecraft;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import ru.turikhay.tlauncher.user.MinecraftUser;
import ru.turikhay.tlauncher.user.minecraft.strategy.MinecraftAuthenticationException;
import ru.turikhay.tlauncher.user.minecraft.strategy.gos.GameOwnershipValidator;
import ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth.MinecraftServicesAuthenticator;
import ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth.MinecraftServicesToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthCodeRequestStrategy;
import ru.turikhay.tlauncher.user.minecraft.strategy.oareq.MicrosoftOAuthExchangeCode;
import ru.turikhay.tlauncher.user.minecraft.strategy.oatoken.MicrosoftOAuthToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.oatoken.exchange.MicrosoftOAuthCodeExchanger;
import ru.turikhay.tlauncher.user.minecraft.strategy.pconv.MinecraftProfileConverter;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.MinecraftOAuthProfile;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.MinecraftProfileRequester;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.ProfileNotCreatedException;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.create.MinecraftProfileCreator;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.XboxServiceAuthenticationResponse;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.auth.XboxLiveAuthenticator;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.xsts.XSTSAuthenticator;

public class MinecraftOAuthAuthenticate {
    private final MicrosoftOAuthCodeRequestStrategy microsoftOAuthCodeRequestStrategy;
    private final MicrosoftOAuthCodeExchanger microsoftOAuthCodeExchanger;
    private final XboxLiveAuthenticator xboxLiveAuthenticator;
    private final XSTSAuthenticator xstsAuthenticator;
    private final MinecraftServicesAuthenticator minecraftServicesAuthenticator;
    private final GameOwnershipValidator gameOwnershipValidator;
    private final MinecraftProfileRequester minecraftProfileRequester;
    private final MinecraftProfileCreator minecraftProfileCreator;
    private final MinecraftProfileConverter minecraftProfileConverter;

    public MinecraftOAuthAuthenticate(MicrosoftOAuthCodeRequestStrategy microsoftOAuthCodeRequestStrategy, MicrosoftOAuthCodeExchanger microsoftOAuthCodeExchanger, XboxLiveAuthenticator xboxLiveAuthenticator, XSTSAuthenticator xstsAuthenticator, MinecraftServicesAuthenticator minecraftServicesAuthenticator, GameOwnershipValidator gameOwnershipValidator, MinecraftProfileRequester minecraftProfileRequester, MinecraftProfileCreator minecraftProfileCreator, MinecraftProfileConverter minecraftProfileConverter) {
        this.microsoftOAuthCodeRequestStrategy = microsoftOAuthCodeRequestStrategy;
        this.microsoftOAuthCodeExchanger = microsoftOAuthCodeExchanger;
        this.xboxLiveAuthenticator = xboxLiveAuthenticator;
        this.xstsAuthenticator = xstsAuthenticator;
        this.minecraftServicesAuthenticator = minecraftServicesAuthenticator;
        this.gameOwnershipValidator = gameOwnershipValidator;
        this.minecraftProfileRequester = minecraftProfileRequester;
        this.minecraftProfileCreator = minecraftProfileCreator;
        this.minecraftProfileConverter = minecraftProfileConverter;
    }

    public MinecraftUser authenticate() throws MinecraftAuthenticationException, InterruptedException, IOException, TimeoutException {
        MinecraftOAuthProfile profile;
        MicrosoftOAuthExchangeCode oareq = this.microsoftOAuthCodeRequestStrategy.requestMicrosoftOAuthCode();
        MicrosoftOAuthToken oaex = this.microsoftOAuthCodeExchanger.exchangeMicrosoftOAuthCode(oareq);
        XboxServiceAuthenticationResponse xbAuth = this.xboxLiveAuthenticator.xboxLiveAuthenticate(oaex.getAccessToken());
        XboxServiceAuthenticationResponse xbXsts = this.xstsAuthenticator.xstsAuthenticate(xbAuth.getToken());
        MinecraftServicesToken mcsToken = this.minecraftServicesAuthenticator.minecraftServicesAuthenticate(xbXsts);
        this.gameOwnershipValidator.checkGameOwnership(mcsToken);
        try {
            profile = this.minecraftProfileRequester.requestProfile(mcsToken);
        }
        catch (ProfileNotCreatedException e) {
            profile = this.minecraftProfileCreator.createProfile(mcsToken);
        }
        return this.minecraftProfileConverter.convertToMinecraftUser(oaex, mcsToken, profile);
    }
}

