/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import ru.turikhay.tlauncher.managed.ManagedListener;
import ru.turikhay.tlauncher.user.ElyLegacyUser;
import ru.turikhay.tlauncher.user.ElyUser;
import ru.turikhay.tlauncher.user.McleaksUser;
import ru.turikhay.tlauncher.user.MinecraftUser;
import ru.turikhay.tlauncher.user.MojangUser;
import ru.turikhay.tlauncher.user.PlainUser;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.tlauncher.user.UserJsonizer;
import ru.turikhay.tlauncher.user.UserSet;

public class UserSetJsonizer
implements JsonDeserializer<UserSet>,
JsonSerializer<UserSet> {
    private final Map<String, UserJsonizer<?>> jsonizerMap;
    private final ManagedListener<User> listener;

    public UserSetJsonizer(ManagedListener<User> listener) {
        this.listener = Objects.requireNonNull(listener, "listener");
        this.jsonizerMap = new HashMap();
        this.jsonizerMap.put("mojang", MojangUser.getJsonizer());
        this.jsonizerMap.put("minecraft", MinecraftUser.getJsonizer());
        this.jsonizerMap.put("plain", PlainUser.getJsonizer());
        this.jsonizerMap.put("ely", ElyUser.getJsonizer());
        this.jsonizerMap.put("ely_legacy", ElyLegacyUser.getJsonizer());
        this.jsonizerMap.put("mcleaks", McleaksUser.getJsonizer());
    }

    public UserSet deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject root = json.getAsJsonObject();
        UserSet set = new UserSet(this.listener);
        JsonArray array = root.getAsJsonArray("list");
        for (JsonElement elem : array) {
            set.add(this.deserializeUser(elem, context));
        }
        if (root.has("selected")) {
            SelectedUser selectedUserRaw = (SelectedUser)context.deserialize((JsonElement)root.getAsJsonObject("selected"), SelectedUser.class);
            User selectedUser = set.getByUsername(selectedUserRaw.username, selectedUserRaw.type);
            set.select(selectedUser);
        }
        return set;
    }

    private User deserializeUser(JsonElement json, JsonDeserializationContext context) {
        JsonObject object = json.getAsJsonObject();
        String type = object.getAsJsonPrimitive("type").getAsString();
        UserJsonizer<?> jsonizer = this.jsonizerMap.get(type);
        if (jsonizer == null) {
            throw new IllegalArgumentException("could not find jsonizer: " + type);
        }
        return jsonizer.deserialize(object, context);
    }

    public JsonElement serialize(UserSet src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject root = new JsonObject();
        if (src.getSelected() != null) {
            root.add("selected", context.serialize((Object)new SelectedUser((User)src.getSelected())));
        }
        JsonArray array = new JsonArray();
        for (User user : src.getSet()) {
            String type = user.getType();
            UserJsonizer<?> jsonizer = this.jsonizerMap.get(type);
            if (jsonizer == null) {
                throw new IllegalArgumentException("jsonizer not found: " + type);
            }
            JsonObject userObject = jsonizer.serialize(user, context);
            if (userObject.has("type")) {
                throw new IllegalArgumentException("serialized object already has \"type\"");
            }
            userObject.addProperty("type", type);
            array.add((JsonElement)userObject);
        }
        root.add("list", (JsonElement)array);
        return root;
    }

    private static class SelectedUser {
        private String username;
        private String type;

        public SelectedUser() {
        }

        public SelectedUser(User user) {
            if (user == null) {
                return;
            }
            this.username = user.getUsername();
            this.type = user.getType();
        }
    }
}

