/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import ru.turikhay.tlauncher.managed.ManagedListener;
import ru.turikhay.tlauncher.managed.ManagedSet;
import ru.turikhay.tlauncher.user.Auth;
import ru.turikhay.tlauncher.user.AuthException;
import ru.turikhay.tlauncher.user.MojangAuth;
import ru.turikhay.tlauncher.user.PlainAuth;
import ru.turikhay.tlauncher.user.User;

public final class UserSet
extends ManagedSet<User> {
    private final Map<String, Auth<? extends User>> authMap = new HashMap<String, Auth<? extends User>>();

    public UserSet(ManagedListener<User> listener) {
        super(listener);
        this.authMap.put("mojang", new MojangAuth());
        this.authMap.put("plain", new PlainAuth());
    }

    public User getByUsername(String username, String type) {
        for (User user : this.getSet()) {
            if (!user.getUsername().equals(username) || type != null && !user.getType().equals(type)) continue;
            return user;
        }
        return null;
    }

    public <U extends User> void validate(U user) throws IOException, AuthException {
        String type = Objects.requireNonNull(user, "user").getType();
        Auth<? extends User> auth = this.authMap.get(type);
        if (auth == null) {
            throw new IllegalArgumentException("auth not found: " + type);
        }
        auth.validate(user);
    }

    public Optional<? extends User> findByType(String type) {
        for (User user : this.getSet()) {
            if (!user.getType().equals(type)) continue;
            return Optional.of(user);
        }
        return Optional.empty();
    }
}

