/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import com.sun.net.httpserver.HttpServer;
import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.user.ElyAuthCode;
import ru.turikhay.tlauncher.user.ElyAuthFlow;
import ru.turikhay.tlauncher.user.ElyAuthStrategyException;
import ru.turikhay.tlauncher.user.PrimaryElyAuthFlowListener;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.async.ExtendedThread;
import ru.turikhay.util.git.MapTokenResolver;
import ru.turikhay.util.git.TokenReplacingReader;

public class PrimaryElyAuthFlow
extends ElyAuthFlow<PrimaryElyAuthFlowListener> {
    private static final Logger LOGGER = LogManager.getLogger(PrimaryElyAuthFlow.class);
    private static final String SERVER_ADDRESS = "http://127.0.0.1:%d";
    private static final String SERVER_ENTRY_POINT = "/";
    static final String SERVER_FULL_URL = "http://127.0.0.1:%d/";
    static final String QUERY_CODE_KEY = "code";
    static final String QUERY_STATE_KEY = "state";
    private static final int PORT_CREATING_TRIES = 5;
    private static final int SERVER_BACKLOG = 1;
    private static final int SERVER_STOP_DELAY = 5;
    static final String TOKEN_EXCHANGE_SUCCESS = "https://account.ely.by/oauth2/code/success?appName=Legacy%20Launcher";
    HttpServerAdapter server;
    static final String SERVER_RESPONSE = "<!DOCTYPE html><html><head><title>Legacy Launcher</title></head><body>${text}</body></html>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ElyAuthCode fetchCode() throws ElyAuthStrategyException, InterruptedException {
        int state = this.generateState();
        URIWatchdog watchdog = this.createWatchdog(state);
        this.server = this.createServer(watchdog);
        try {
            this.server.start();
            this.openBrowser(this.server.getPort(), state);
            ElyAuthCode elyAuthCode = watchdog.waitForCode();
            return elyAuthCode;
        }
        finally {
            this.server.stop();
        }
    }

    @Override
    protected void onCancelled() {
        this.server.stop();
    }

    private String getRedirectUri(int port) {
        return String.format(Locale.ROOT, SERVER_FULL_URL, port);
    }

    URIWatchdog createWatchdog(int state) {
        return new URIWatchdog(state);
    }

    HttpServerAdapter createServer(URIWatchdog watchdog) throws ElyAuthStrategyException, InterruptedException {
        LOGGER.debug("Creating server...");
        int portCreatingTries = 0;
        IOException ex = null;
        do {
            HttpServerAdapter adapter;
            this.checkCancelled();
            int port = ThreadLocalRandom.current().nextInt(49152, 65535);
            LOGGER.debug("attempt {}; selected port: {}", (Object)(++portCreatingTries), (Object)port);
            try {
                adapter = new HttpServerAdapter(watchdog, port, watchdog.getCheckState());
            }
            catch (IOException ioE) {
                if (ex == null) {
                    ex = ioE;
                    continue;
                }
                ex.addSuppressed(ioE);
                continue;
            }
            catch (Exception e) {
                throw new ElyAuthStrategyException("Unknown error", e);
            }
            for (PrimaryElyAuthFlowListener listener : this.getListenerList()) {
                listener.primaryStrategyServerCreated(this, port);
            }
            return adapter;
        } while (portCreatingTries < 5);
        throw new ElyAuthStrategyException("Max port occupy tries exceed", ex);
    }

    void openBrowser(int port, int state) throws InterruptedException {
        this.openBrowser(this.getRedirectUri(port), state);
    }

    private static Map<String, String> splitQuery(String query) {
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        String[] pairs = StringUtils.split((String)query, (char)'&');
        try {
            for (String pair : pairs) {
                int idx = StringUtils.indexOf((CharSequence)pair, (int)61);
                query_pairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException encoding) {
            throw new Error("UTF-8 is unsupported");
        }
        return query_pairs;
    }

    class URIWatchdog
    extends ExtendedThread {
        private final Object wait = new Object();
        private final int state;
        private volatile URI uri;
        private ElyAuthCode code;

        private URIWatchdog(int state) {
            this.state = state;
            LOGGER.debug("Starting watchdog...");
            this.startAndWait();
            this.unlockThread("start");
            LOGGER.debug("Started");
        }

        int getCheckState() {
            return this.state;
        }

        ElyAuthCode parseURI(URI uri, String redirect_uri, int state) {
            String query = uri.toString().substring(PrimaryElyAuthFlow.SERVER_ENTRY_POINT.length() + 1);
            Map queryMap = PrimaryElyAuthFlow.splitQuery(query);
            if (Integer.parseInt((String)queryMap.get(PrimaryElyAuthFlow.QUERY_STATE_KEY)) != state) {
                throw new IllegalArgumentException(PrimaryElyAuthFlow.QUERY_STATE_KEY);
            }
            return new ElyAuthCode((String)queryMap.get(PrimaryElyAuthFlow.QUERY_CODE_KEY), redirect_uri, state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean passURI(URI uri, String redirect_uri, int state) {
            LOGGER.debug("uri passed externally: {}", (Object)uri);
            try {
                this.parseURI(uri, redirect_uri, state);
            }
            catch (Exception e) {
                LOGGER.debug("invalid uri passed:", (Throwable)e);
                return false;
            }
            this.uri = uri;
            Object object = this.wait;
            synchronized (object) {
                this.wait.notifyAll();
            }
            return true;
        }

        ElyAuthCode waitForCode() throws InterruptedException {
            if (this.isAlive()) {
                this.join();
            }
            return this.code;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.lockThread("start");
            while (true) {
                LOGGER.trace("iteration");
                URI currentURI = this.uri;
                while (currentURI == this.uri) {
                    LOGGER.trace("still same: {} vs {}", (Object)currentURI, (Object)this.uri);
                    Object object = this.wait;
                    synchronized (object) {
                        LOGGER.trace("waiting");
                        try {
                            this.wait.wait();
                        }
                        catch (InterruptedException interrupted) {
                            return;
                        }
                    }
                }
                LOGGER.debug("got new uri");
                currentURI = this.uri;
                try {
                    this.code = this.parseURI(currentURI, PrimaryElyAuthFlow.this.getRedirectUri(PrimaryElyAuthFlow.this.server.port), this.state);
                    LOGGER.debug("got the code {}", (Object)this.code);
                    return;
                }
                catch (Exception e) {
                    for (PrimaryElyAuthFlowListener listener : PrimaryElyAuthFlow.this.getListenerList()) {
                        Boolean result;
                        try {
                            result = PrimaryElyAuthFlow.this.join(listener.primaryStrategyCodeParseFailed(PrimaryElyAuthFlow.this, currentURI));
                        }
                        catch (InterruptedException interrupted) {
                            return;
                        }
                        if (result == null || result.booleanValue()) continue;
                        Thread.interrupted();
                        return;
                    }
                    LOGGER.debug("one more loop", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    class HttpServerAdapter {
        private final URIWatchdog watchdog;
        private final HttpServer server;
        private final int port;
        private final int state;

        private HttpServerAdapter(URIWatchdog watchdog, int port, int state) throws IOException {
            LOGGER.debug("Creating HttpServerAdapter at port {}", (Object)port);
            this.watchdog = Objects.requireNonNull(watchdog, "watchdog");
            this.port = port;
            this.state = state;
            this.server = HttpServer.create(new InetSocketAddress(port), 1);
            this.server.createContext(PrimaryElyAuthFlow.SERVER_ENTRY_POINT, httpExchange -> {
                try {
                    String response;
                    int responseStatus;
                    LOGGER.debug("handling uri: {}", (Object)httpExchange.getRequestURI());
                    if (this.watchdog.passURI(httpExchange.getRequestURI(), PrimaryElyAuthFlow.this.getRedirectUri(this.port), this.state)) {
                        responseStatus = 302;
                        response = TokenReplacingReader.resolveVars(PrimaryElyAuthFlow.SERVER_RESPONSE, new MapTokenResolver((Map<String, String>)new HashMap<String, String>(){
                            {
                                this.put("text", Localizable.get("account.manager.multipane.process-account-ely.flow.complete.response"));
                            }
                        }));
                    } else {
                        responseStatus = 400;
                        response = "\r\n";
                    }
                    httpExchange.getResponseHeaders().set("Content-Type", "text/html; charset=" + FileUtil.getCharset().name());
                    if (responseStatus == 302) {
                        httpExchange.getResponseHeaders().set("Location", PrimaryElyAuthFlow.TOKEN_EXCHANGE_SUCCESS);
                    }
                    httpExchange.sendResponseHeaders(responseStatus, response.getBytes(FileUtil.getCharset()).length);
                    OutputStream out = httpExchange.getResponseBody();
                    IOUtils.write((String)response, (OutputStream)out, (Charset)FileUtil.getCharset());
                    out.close();
                }
                catch (Exception e) {
                    LOGGER.error("Interrupting watchdog because of Server (port {}) failure", (Object)port, (Object)e);
                    Sentry.capture((EventBuilder)new EventBuilder().withMessage("internal server crashed").withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)).withLevel(Event.Level.ERROR));
                    this.watchdog.interrupt();
                }
            });
            this.server.setExecutor(null);
            LOGGER.debug("HttpServer created successfully");
        }

        int getPort() {
            return this.port;
        }

        int getState() {
            return this.state;
        }

        void start() {
            LOGGER.debug("Http server started at port {}", (Object)this.port);
            this.server.start();
        }

        void stop() {
            LOGGER.debug("Http server stopped at port {}", (Object)this.port);
            this.server.stop(5);
        }
    }
}

