/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.exceptions.AuthenticationException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.apache.http.client.fluent.Request;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.user.AuthlibUserPayload;
import ru.turikhay.tlauncher.user.MojangAuth;
import ru.turikhay.tlauncher.user.MojangLikeUser;
import ru.turikhay.tlauncher.user.MojangLikeUserFactory;
import ru.turikhay.tlauncher.user.MojangLikeUserJsonizer;
import ru.turikhay.tlauncher.user.MojangUserMigrationStatus;
import ru.turikhay.util.Lazy;
import ru.turikhay.util.async.AsyncThread;

public class MojangUser
extends MojangLikeUser {
    private static final Logger LOGGER = LogManager.getLogger(MojangUser.class);
    public static final String TYPE = "mojang";
    public static final MojangLikeUserFactory<MojangUser> FACTORY = MojangUser::new;
    private final Lazy<CompletableFuture<MojangUserMigrationStatus>> migrateQueryJob = Lazy.of(() -> CompletableFuture.supplyAsync(() -> {
        JsonElement elem;
        try {
            this.getMojangUserAuthentication().logIn();
        }
        catch (AuthenticationException e) {
            LOGGER.warn("Couldn't log in {} before checking the migration status", (Object)this.getDisplayName(), (Object)e);
            return new MojangUserMigrationStatus((Exception)((Object)e));
        }
        try {
            elem = JsonParser.parseString((String)Request.Get((String)"https://api.minecraftservices.com/rollout/v1/msamigration").addHeader("Authorization", "Bearer " + this.getMojangUserAuthentication().getAuthenticatedToken()).execute().returnContent().asString(StandardCharsets.UTF_8));
        }
        catch (IOException | RuntimeException e) {
            LOGGER.warn("Couldn't fetch migration status for {}", (Object)this.getDisplayName(), (Object)e);
            return new MojangUserMigrationStatus(e);
        }
        boolean canMigrate = elem instanceof JsonObject && ((JsonObject)elem).has("rollout") && ((JsonObject)elem).getAsJsonPrimitive("rollout").getAsBoolean();
        LOGGER.debug("Can {} migrate? {}", (Object)this.getDisplayName(), (Object)canMigrate);
        return new MojangUserMigrationStatus(canMigrate);
    }, AsyncThread.SHARED_SERVICE));

    MojangUser(AuthlibUserPayload payload) {
        super(payload);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public Lazy<CompletableFuture<MojangUserMigrationStatus>> isReadyToMigrate() {
        return this.migrateQueryJob;
    }

    public MojangUserMigrationStatus.Status getMigrationStatusNow() {
        return this.migrateQueryJob.valueIfInitialized().map(f -> f.getNow(null)).map(MojangUserMigrationStatus::asStatus).orElse(MojangUserMigrationStatus.Status.NONE);
    }

    public static MojangLikeUserJsonizer<MojangUser> getJsonizer() {
        return new MojangLikeUserJsonizer<MojangUser>(new MojangAuth(), FACTORY);
    }
}

