/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import ru.turikhay.tlauncher.user.MinecraftUser;
import ru.turikhay.tlauncher.user.UserJsonizer;
import ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth.MinecraftServicesToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.oatoken.MicrosoftOAuthToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.MinecraftOAuthProfile;

public class MinecraftUserJsonizer
extends UserJsonizer<MinecraftUser> {
    @Override
    public JsonObject serialize(MinecraftUser src, JsonSerializationContext context) {
        return (JsonObject)context.serialize((Object)new Payload(src));
    }

    @Override
    public MinecraftUser deserialize(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        return ((Payload)context.deserialize((JsonElement)json, Payload.class)).toUser();
    }

    private static class Payload {
        final UUID id;
        final String name;
        final MinecraftTokenPayload minecraft;
        final MicrosoftTokenPayload microsoft;

        Payload(MinecraftUser src) {
            this.id = src.getUUID();
            this.name = src.getUsername();
            this.minecraft = new MinecraftTokenPayload(src.getMinecraftToken());
            this.microsoft = new MicrosoftTokenPayload(src.getMicrosoftToken());
        }

        MinecraftUser toUser() {
            return new MinecraftUser(new MinecraftOAuthProfile(Objects.requireNonNull(this.id, "id"), Objects.requireNonNull(this.name, "name")), Objects.requireNonNull(this.microsoft, "microsoftToken").toToken(), Objects.requireNonNull(this.minecraft, "minecraftToken").toToken());
        }
    }

    private static class MicrosoftTokenPayload {
        final String accessToken;
        final String refreshToken;
        final Instant expiresAt;

        MicrosoftTokenPayload(MicrosoftOAuthToken token) {
            this.accessToken = token.getAccessToken();
            this.refreshToken = token.getRefreshToken();
            this.expiresAt = token.calculateExpiryTime();
        }

        MicrosoftOAuthToken toToken() {
            return new MicrosoftOAuthToken(Objects.requireNonNull(this.accessToken, "accessToken"), Objects.requireNonNull(this.refreshToken, "refreshToken"), Objects.requireNonNull(this.expiresAt, "expiresAt"));
        }
    }

    private static class MinecraftTokenPayload {
        final String token;
        final Instant expiresAt;

        MinecraftTokenPayload(MinecraftServicesToken token) {
            this.token = token.getAccessToken();
            this.expiresAt = token.calculateExpiryTime();
        }

        MinecraftServicesToken toToken() {
            return new MinecraftServicesToken(Objects.requireNonNull(this.token, "token"), Objects.requireNonNull(this.expiresAt, "expiresAt"));
        }
    }
}

