/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import java.util.Objects;
import java.util.UUID;
import ru.turikhay.tlauncher.user.LoginCredentials;
import ru.turikhay.tlauncher.user.MinecraftUserJsonizer;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth.MinecraftServicesToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.oatoken.MicrosoftOAuthToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.MinecraftOAuthProfile;

public class MinecraftUser
extends User {
    public static final String TYPE = "minecraft";
    private MinecraftOAuthProfile profile;
    private MicrosoftOAuthToken microsoftToken;
    private MinecraftServicesToken minecraftToken;

    public MinecraftUser(MinecraftOAuthProfile profile, MicrosoftOAuthToken microsoftToken, MinecraftServicesToken minecraftToken) {
        this.setPayload(profile, microsoftToken, minecraftToken);
    }

    @Override
    public String getUsername() {
        return this.profile.getName();
    }

    @Override
    public String getDisplayName() {
        return this.profile.getName();
    }

    @Override
    public UUID getUUID() {
        return this.profile.getId();
    }

    public MicrosoftOAuthToken getMicrosoftToken() {
        return this.microsoftToken;
    }

    public MinecraftServicesToken getMinecraftToken() {
        return this.minecraftToken;
    }

    void setPayload(MinecraftOAuthProfile profile, MicrosoftOAuthToken microsoftToken, MinecraftServicesToken minecraftToken) {
        this.setProfile(profile);
        this.setMicrosoftToken(microsoftToken);
        this.setMinecraftToken(minecraftToken);
    }

    public void setProfile(MinecraftOAuthProfile profile) {
        this.profile = Objects.requireNonNull(profile, "profile");
    }

    void setMicrosoftToken(MicrosoftOAuthToken microsoftToken) {
        this.microsoftToken = Objects.requireNonNull(microsoftToken, "microsoftToken");
    }

    void setMinecraftToken(MinecraftServicesToken minecraftToken) {
        this.minecraftToken = Objects.requireNonNull(minecraftToken, "minecraftToken");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected boolean equals(User user) {
        return user != null && this.profile.getId().equals(((MinecraftUser)user).profile.getId());
    }

    @Override
    public int hashCode() {
        int result = this.profile.hashCode();
        result = 31 * result + this.microsoftToken.hashCode();
        result = 31 * result + this.minecraftToken.hashCode();
        return result;
    }

    @Override
    public LoginCredentials getLoginCredentials() {
        return new LoginCredentials(this.profile.getName(), this.minecraftToken.getAccessToken(), "{}", this.profile.getName(), this.profile.getId(), "mojang", this.profile.getName());
    }

    public static MinecraftUserJsonizer getJsonizer() {
        return new MinecraftUserJsonizer();
    }
}

