/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import io.sentry.Sentry;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.SentryInterface;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.user.Auth;
import ru.turikhay.tlauncher.user.AuthException;
import ru.turikhay.tlauncher.user.MinecraftUser;
import ru.turikhay.tlauncher.user.minecraft.oauth.OAuthApplication;
import ru.turikhay.tlauncher.user.minecraft.strategy.MinecraftAuthenticationException;
import ru.turikhay.tlauncher.user.minecraft.strategy.gos.GameOwnershipValidationException;
import ru.turikhay.tlauncher.user.minecraft.strategy.gos.GameOwnershipValidator;
import ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth.MinecraftServicesAuthenticationException;
import ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth.MinecraftServicesAuthenticator;
import ru.turikhay.tlauncher.user.minecraft.strategy.mcsauth.MinecraftServicesToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.oatoken.MicrosoftOAuthToken;
import ru.turikhay.tlauncher.user.minecraft.strategy.oatoken.refresh.MicrosoftOAuthTokenRefreshException;
import ru.turikhay.tlauncher.user.minecraft.strategy.oatoken.refresh.MicrosoftOAuthTokenRefresher;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.MinecraftOAuthProfile;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.MinecraftProfileRequestException;
import ru.turikhay.tlauncher.user.minecraft.strategy.preq.MinecraftProfileRequester;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.XboxServiceAuthenticationResponse;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.auth.XboxLiveAuthenticationException;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.auth.XboxLiveAuthenticator;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.xsts.XSTSAuthenticationException;
import ru.turikhay.tlauncher.user.minecraft.strategy.xb.xsts.XSTSAuthenticator;

public class MinecraftAuth
implements Auth<MinecraftUser> {
    private static final Logger LOGGER = LogManager.getLogger(MinecraftAuth.class);
    private final OAuthApplication APP = OAuthApplication.TL;

    @Override
    public void validate(MinecraftUser user) throws AuthException, IOException {
        MinecraftOAuthProfile profile;
        if (user.getMinecraftToken().isExpired()) {
            this.refreshMinecraftAccessToken(user);
        }
        MinecraftProfileRequester requester = new MinecraftProfileRequester();
        try {
            profile = requester.requestProfile(user.getMinecraftToken());
        }
        catch (MinecraftProfileRequestException e) {
            throw MinecraftAuth.wrap(e);
        }
        catch (IOException ioE) {
            MinecraftAuth.captureIOException("requesting profile", ioE);
            throw ioE;
        }
        LOGGER.info("Profile validated: {}", (Object)profile);
        user.setProfile(profile);
    }

    private void refreshMinecraftAccessToken(MinecraftUser user) throws AuthException, IOException {
        MinecraftServicesToken mcsToken;
        if (user.getMicrosoftToken().isExpired()) {
            this.refreshMicrosoftAccessToken(user);
        }
        XboxServiceAuthenticationResponse xstsToken = this.authenticateOnXboxServices(user);
        MinecraftServicesAuthenticator mcsAuthenticator = new MinecraftServicesAuthenticator();
        try {
            mcsToken = mcsAuthenticator.minecraftServicesAuthenticate(xstsToken);
        }
        catch (MinecraftServicesAuthenticationException e) {
            throw MinecraftAuth.wrap(e);
        }
        catch (IOException ioE) {
            MinecraftAuth.captureIOException("mcs auth", ioE);
            throw ioE;
        }
        GameOwnershipValidator ownershipValidator = new GameOwnershipValidator();
        try {
            ownershipValidator.checkGameOwnership(mcsToken);
        }
        catch (GameOwnershipValidationException e) {
            throw MinecraftAuth.wrap(e);
        }
        catch (IOException ioE) {
            MinecraftAuth.captureIOException("checking ownership", ioE);
            throw ioE;
        }
        user.setMinecraftToken(mcsToken);
    }

    private XboxServiceAuthenticationResponse authenticateOnXboxServices(MinecraftUser user) throws AuthException, IOException {
        XboxServiceAuthenticationResponse xstsToken;
        XboxServiceAuthenticationResponse xboxLiveToken;
        XboxLiveAuthenticator xboxLiveAuthenticator = new XboxLiveAuthenticator(this.APP);
        try {
            xboxLiveToken = xboxLiveAuthenticator.xboxLiveAuthenticate(user.getMicrosoftToken());
        }
        catch (XboxLiveAuthenticationException e) {
            throw MinecraftAuth.wrap(e);
        }
        catch (IOException ioE) {
            MinecraftAuth.captureIOException("xbox live auth", ioE);
            throw ioE;
        }
        XSTSAuthenticator xstsAuthenticator = new XSTSAuthenticator();
        try {
            xstsToken = xstsAuthenticator.xstsAuthenticate(xboxLiveToken.getToken());
        }
        catch (XSTSAuthenticationException e) {
            throw MinecraftAuth.wrap(e);
        }
        catch (IOException ioE) {
            MinecraftAuth.captureIOException("xsts auth", ioE);
            throw ioE;
        }
        return xstsToken;
    }

    private void refreshMicrosoftAccessToken(MinecraftUser user) throws AuthException, IOException {
        MicrosoftOAuthToken token;
        MicrosoftOAuthTokenRefresher refresher = new MicrosoftOAuthTokenRefresher(this.APP);
        try {
            token = refresher.refreshToken(user.getMicrosoftToken());
        }
        catch (MicrosoftOAuthTokenRefreshException e) {
            throw MinecraftAuth.wrap(e);
        }
        catch (IOException ioE) {
            MinecraftAuth.captureIOException("refreshing msft", ioE);
            throw ioE;
        }
        user.setMicrosoftToken(token);
    }

    private static AuthException wrap(MinecraftAuthenticationException e) {
        LOGGER.error("Couldn't validate the user", (Throwable)e);
        Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)).withMessage("couldn't validate Microsoft user"));
        return new AuthException(e.toString(), e.getShortKey(), new Object[0]);
    }

    private static void captureIOException(String phase, IOException e) {
        Sentry.capture((EventBuilder)new EventBuilder().withLevel(Event.Level.ERROR).withSentryInterface((SentryInterface)new ExceptionInterface((Throwable)e)).withMessage("i/o validating Microsoft user while " + phase));
    }
}

