/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.response.Response;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import javax.net.ssl.HttpsURLConnection;
import ru.turikhay.tlauncher.managers.McleaksManager;
import ru.turikhay.tlauncher.user.AuthException;
import ru.turikhay.tlauncher.user.AuthlibAuth;
import ru.turikhay.tlauncher.user.InvalidCredentialsException;
import ru.turikhay.tlauncher.user.McleaksAltTokenExpired;
import ru.turikhay.tlauncher.user.McleaksUser;
import ru.turikhay.util.StringUtil;
import ru.turikhay.util.U;

public class McleaksAuth
extends AuthlibAuth<McleaksUser> {
    public McleaksUser authorize(String altToken) throws AuthException, IOException {
        UserAuthentication userAuthentication;
        McleaksAuth.checkAvailable();
        String clientToken = McleaksAuth.randomClientToken();
        try {
            userAuthentication = super.authorize(clientToken, altToken, "12345");
        }
        catch (InvalidCredentialsException inv) {
            throw new McleaksAltTokenExpired();
        }
        return new McleaksUser(altToken, clientToken, userAuthentication);
    }

    @Override
    protected void logIn(UserAuthentication userAuthentication) throws AuthException, IOException {
        block2: {
            McleaksAuth.checkAvailable();
            try {
                super.logIn(userAuthentication);
            }
            catch (InvalidCredentialsException inv) {
                if (inv.getMessage() == null || !inv.getMessage().contains("ALT-TOKEN")) break block2;
                throw new McleaksAltTokenExpired();
            }
        }
    }

    @Override
    public void validate(McleaksUser user) throws AuthException, IOException {
        McleaksAuth.checkAvailable();
        super.validate(user);
    }

    @Override
    protected YggdrasilAuthenticationService createYggdrasilAuthenticationService(String clientToken) {
        return new YggdrasilAuthenticationService(U.getProxy(), StringUtil.requireNotBlank(clientToken)){

            protected <T extends Response> T makeRequest(URL url, Object input, Class<T> classOfT) throws AuthenticationException {
                URL newUrl;
                if (url.getProtocol().equals("https")) {
                    try {
                        final HttpsURLConnection connection = McleaksManager.getConnector().setupHttpsConnection(url);
                        newUrl = new URL(null, url.toExternalForm(), new URLStreamHandler(){

                            @Override
                            protected URLConnection openConnection(URL u) {
                                return connection;
                            }

                            @Override
                            protected URLConnection openConnection(URL u, Proxy p) {
                                return connection;
                            }
                        });
                    }
                    catch (IOException ioE) {
                        throw new AuthenticationUnavailableException((Throwable)ioE);
                    }
                } else {
                    newUrl = url;
                }
                return (T)super.makeRequest(newUrl, input, classOfT);
            }
        };
    }

    private static void checkAvailable() throws AuthException {
        if (McleaksManager.isUnsupported()) {
            throw new AuthException("MCLeaks is unsupported", "mcleaks.unsupported", new Object[0]);
        }
        if (!McleaksManager.getStatus().hasStatus()) {
            throw new AuthException("MCLeaks status is unknown", "mcleaks.status-unknown", new Object[0]);
        }
        if (McleaksManager.getStatus().getServerIp() == null) {
            throw new AuthException("MCLeaks is unavailable", "mcleaks.unavailable", new Object[0]);
        }
    }
}

