/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import ru.turikhay.tlauncher.minecraft.auth.UUIDTypeAdapter;
import ru.turikhay.util.StringUtil;

public class LoginCredentials {
    private final String username;
    private final String session;
    private final String accessToken;
    private final String playerName;
    private final String userType;
    private final String profileName;
    private final String properties;
    private final UUID uuid;

    LoginCredentials(String username, String accessToken, String properties, String playerName, UUID uuid, String userType, String profileName) {
        this.username = StringUtil.requireNotBlank(username, "username");
        this.accessToken = StringUtil.requireNotBlank(accessToken, "accessToken");
        this.properties = StringUtils.isBlank((CharSequence)properties) ? "{}" : properties;
        this.playerName = StringUtil.requireNotBlank(playerName, "playerName");
        this.uuid = Objects.requireNonNull(uuid, "uuid");
        this.userType = StringUtil.requireNotBlank(userType, "userType");
        this.profileName = StringUtil.requireNotBlank(profileName, "profileName");
        this.session = String.format(Locale.ROOT, "token:%s:%s", accessToken, UUIDTypeAdapter.fromUUID(uuid));
    }

    public String getUsername() {
        return this.username;
    }

    public String getSession() {
        return this.session;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public String getUserType() {
        return this.userType;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getProperties() {
        return this.properties;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public LinkedHashMap<String, String> map() {
        return new LinkedHashMap<String, String>(){
            {
                this.put("auth_username", LoginCredentials.this.username);
                this.put("auth_session", LoginCredentials.this.session);
                this.put("auth_access_token", LoginCredentials.this.accessToken);
                this.put("user_properties", LoginCredentials.this.properties);
                this.put("auth_player_name", LoginCredentials.this.playerName);
                this.put("auth_uuid", UUIDTypeAdapter.fromUUID(LoginCredentials.this.uuid));
                this.put("user_type", LoginCredentials.this.userType);
                this.put("profile_name", LoginCredentials.this.profileName);
            }
        };
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("session", (Object)this.session).append("accessToken", (Object)this.accessToken).append("playerName", (Object)this.playerName).append("userType", (Object)this.userType).append("profileName", (Object)this.profileName).append("properties", (Object)this.properties).append("uuid", (Object)this.uuid).build();
    }
}

