/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.user.ElyUser;
import ru.turikhay.tlauncher.user.ElyUserJsonizer;
import ru.turikhay.tlauncher.user.InvalidCredentialsException;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.StringUtil;
import ru.turikhay.util.U;
import ru.turikhay.util.git.MapTokenResolver;
import ru.turikhay.util.git.TokenReplacingReader;

class ElyUserValidator {
    private static final Logger LOGGER = LogManager.getLogger(ElyUserValidator.class);
    static final String ACCOUNT_INFO = "https://account.ely.by/api/account/v1/info";
    static final String TOKEN_REFRESH_REQUEST = "grant_type=refresh_token&client_id=tlauncher&client_secret=SbOVmJHBCjMV1NsewphGgA2SbyrVjN7IBcOte6b1HR7JGup2&refresh_token=${refresh_token}";
    private String accessToken;
    private String refreshToken;
    private Long expiryTime;
    private ElyUser user;
    private final Gson gson = new GsonBuilder().create();

    ElyUserValidator(ElyUser user) {
        Objects.requireNonNull(user, "user");
        this.updateUser(user);
        LOGGER.debug("user validator created for user: {}", (Object)user);
    }

    public void validateUser() throws IOException, InvalidCredentialsException {
        Response<ElyUserJsonizer.ElySerialize> rawUserResponse;
        block4: {
            block6: {
                block7: {
                    block5: {
                        LOGGER.debug("validating user...");
                        rawUserResponse = this.getUserInfo();
                        if (rawUserResponse.error == null) break block4;
                        if (!rawUserResponse.error.isTokenExpired()) break block5;
                        LOGGER.debug("token has expired. renewing");
                        break block6;
                    }
                    if (this.expiryTime == null || this.expiryTime - System.currentTimeMillis() >= 0x6DDD00L) break block7;
                    if (this.refreshToken == null) break block4;
                    LOGGER.debug("token will expire in less than two hours. renewing");
                    break block6;
                }
                rawUserResponse = this.getUserInfo();
                if (rawUserResponse.error != null) {
                    if (rawUserResponse.error.isTokenExpired() && this.refreshToken != null) {
                        LOGGER.debug("token has expired. renewing");
                    } else {
                        throw new InvalidCredentialsException(rawUserResponse.error.toString());
                    }
                }
                break block4;
            }
            TokenRefreshResponse response = this.refreshAccessToken();
            this.setToken(response.access_token, this.refreshToken, System.currentTimeMillis() + (long)response.expires_in * 1000L);
            rawUserResponse = this.getUserInfo();
            if (rawUserResponse.error != null) {
                throw new InvalidCredentialsException(rawUserResponse.error.toString());
            }
        }
        ElyUserJsonizer.ElySerialize rawUser = (ElyUserJsonizer.ElySerialize)rawUserResponse.response;
        rawUser.accessToken = this.accessToken;
        rawUser.refreshToken = this.refreshToken;
        rawUser.expiryTime = this.expiryTime;
        this.updateUser(rawUser.create());
    }

    private TokenRefreshResponse refreshAccessToken() throws IOException, InvalidCredentialsException {
        LOGGER.debug("refreshing access token");
        String request = TokenReplacingReader.resolveVars(TOKEN_REFRESH_REQUEST, new MapTokenResolver((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("refresh_token", ElyUserValidator.this.refreshToken);
            }
        }));
        HttpURLConnection connection = ElyUserValidator.setupConnection("https://account.ely.by/api/oauth2/v1/token");
        connection.setDoOutput(true);
        IOUtils.write((String)request, (OutputStream)connection.getOutputStream(), (Charset)FileUtil.getCharset());
        Response<TokenRefreshResponse> tokenRefreshResponse = this.parse(connection, TokenRefreshResponse.class);
        if (tokenRefreshResponse.error != null) {
            throw new InvalidCredentialsException(tokenRefreshResponse.error.toString());
        }
        TokenRefreshResponse response = (TokenRefreshResponse)tokenRefreshResponse.response;
        try {
            response.checkConsistancy();
        }
        catch (RuntimeException rE) {
            throw new IOException("token response is invalid");
        }
        return response;
    }

    private void updateUser(ElyUser user) {
        Objects.requireNonNull(user, "user");
        if (this.user == null) {
            this.user = user;
        } else {
            this.user.copyFrom(user);
        }
        this.setToken(user.getAccessToken(), user.getRefreshToken(), user.getExpiryTime());
    }

    private void setToken(String accessToken, String refreshToken, Long expiryTime) {
        this.accessToken = StringUtil.requireNotBlank(accessToken, "accessToken");
        this.refreshToken = refreshToken;
        if (expiryTime != null && expiryTime < 0L) {
            throw new IllegalArgumentException("expiryTime");
        }
        this.expiryTime = expiryTime;
        if (this.user != null) {
            this.user.setToken(accessToken, refreshToken, expiryTime);
        }
    }

    private static HttpURLConnection setupConnection(String _url) throws IOException {
        URL url = new URL(_url);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(true);
        connection.setReadTimeout(U.getReadTimeout());
        connection.setConnectTimeout(U.getConnectionTimeout());
        return connection;
    }

    private <T> T parse(InputStream input, Class<T> clazz) throws IOException {
        String response = IOUtils.toString((InputStream)input, (Charset)FileUtil.getCharset());
        LOGGER.debug("response: {}", (Object)response);
        try {
            return (T)this.gson.fromJson(response, clazz);
        }
        catch (RuntimeException rE) {
            throw new IOException("could not parse response: \"" + response + "\"", rE);
        }
    }

    private <T> Response<T> parse(HttpURLConnection connection, Class<T> clazz) throws IOException {
        YiiErrorResponse error;
        if (connection.getResponseCode() == 200) {
            try {
                return new Response<T>(this.parse(connection.getInputStream(), clazz));
            }
            catch (Exception e) {
                throw new IOException("could not parse response", e);
            }
        }
        try {
            error = this.parse(connection.getErrorStream(), YiiErrorResponse.class);
        }
        catch (Exception e) {
            throw new IOException("could not read error message", e);
        }
        return new Response(error);
    }

    private Response<ElyUserJsonizer.ElySerialize> getUserInfo() throws IOException {
        HttpURLConnection connection = ElyUserValidator.setupConnection(ACCOUNT_INFO);
        connection.setRequestProperty("Authorization", "Bearer " + this.accessToken);
        return this.parse(connection, ElyUserJsonizer.ElySerialize.class);
    }

    static class Response<T> {
        final YiiErrorResponse error;
        final T response;

        Response(YiiErrorResponse error, T response) {
            this.error = error;
            this.response = response;
            if (error == null && response == null) {
                throw new NullPointerException("error & response");
            }
        }

        Response(YiiErrorResponse error) {
            this(Objects.requireNonNull(error, "error"), null);
        }

        Response(T response) {
            this(null, Objects.requireNonNull(response, "response"));
        }
    }

    static class YiiErrorResponse {
        private String name;
        private String message;
        private String type;
        private int code;
        private int status;

        YiiErrorResponse() {
        }

        boolean isTokenExpired() {
            return "Token expired".equals(this.message) || "Unauthorized".equals(this.name);
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.name).append("message", (Object)this.message).append("type", (Object)this.type).append("code", this.code).append((Object)"status").build();
        }
    }

    static class TokenRefreshResponse {
        private String access_token;
        private String token_type;
        private int expires_in;

        TokenRefreshResponse() {
        }

        void checkConsistancy() {
            StringUtil.requireNotBlank(this.access_token, "access_token");
            if (!"Bearer".equals(this.token_type)) {
                throw new IllegalArgumentException("token type: \"" + this.token_type + "\"");
            }
            if (this.expires_in != 0 && this.expires_in < 0) {
                throw new IllegalArgumentException("expires_in: " + this.expires_in);
            }
        }
    }

    static class TokenExpiredException
    extends InvalidCredentialsException {
        TokenExpiredException(String message) {
            super(message);
        }
    }
}

