/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.user.ElyUser;
import ru.turikhay.tlauncher.user.UserJsonizer;
import ru.turikhay.util.U;

public class ElyUserJsonizer
extends UserJsonizer<ElyUser> {
    @Override
    public JsonObject serialize(ElyUser src, JsonSerializationContext context) {
        return (JsonObject)context.serialize((Object)new ElySerialize(src));
    }

    @Override
    public ElyUser deserialize(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        return ((ElySerialize)context.deserialize((JsonElement)json, ElySerialize.class)).create();
    }

    static class ElySerialize {
        final int id;
        final String username;
        final String displayName;
        final UUID uuid;
        final long registeredAt;
        String accessToken;
        String refreshToken;
        Long expiryTime;

        ElySerialize(ElyUser user) {
            this.id = user.getId();
            this.username = user.getUsername();
            this.displayName = user.getDisplayName();
            this.uuid = user.getUUID();
            this.registeredAt = user.getRegisteredAt().getTime() / 1000L;
            this.accessToken = user.getAccessToken();
            this.refreshToken = user.getRefreshToken();
            this.expiryTime = user.getExpiryTime();
        }

        ElyUser create() {
            return new ElyUser(this.id, this.username, StringUtils.isBlank((CharSequence)this.displayName) ? this.username : this.displayName, this.uuid, U.getUTC(this.registeredAt * 1000L).getTime(), this.accessToken, this.refreshToken, this.expiryTime);
        }
    }
}

