/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.builder.ToStringBuilder;
import ru.turikhay.tlauncher.user.ElyUserJsonizer;
import ru.turikhay.tlauncher.user.LoginCredentials;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.util.StringUtil;

public class ElyUser
extends User {
    public static final String TYPE = "ely";
    private final int id;
    private final Date registeredAt;
    private String username;
    private String displayName;
    private UUID uuid;
    private String accessToken;
    private String refreshToken;
    private Long expiryTime;

    ElyUser(int id, String username, String displayName, UUID uuid, Date registeredAt, String accessToken, String refreshToken, Long expiryTime) {
        if (id < 0) {
            throw new IllegalArgumentException("id");
        }
        this.id = id;
        this.registeredAt = Objects.requireNonNull(registeredAt, "registeredAt");
        this.setUsername(username);
        this.setDisplayName(displayName);
        this.setUUID(uuid);
        this.setToken(accessToken, refreshToken, expiryTime);
    }

    int getId() {
        return this.id;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    void setUsername(String username) {
        this.username = StringUtil.requireNotBlank(username, "username");
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = StringUtil.requireNotBlank(displayName, "displayName");
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    void setUUID(UUID uuid) {
        this.uuid = Objects.requireNonNull(uuid, "uuid");
    }

    Date getRegisteredAt() {
        return this.registeredAt;
    }

    String getAccessToken() {
        return this.accessToken;
    }

    String getRefreshToken() {
        return this.refreshToken;
    }

    Long getExpiryTime() {
        return this.expiryTime;
    }

    void setToken(String accessToken, String refreshToken, Long expiryTime) {
        if (expiryTime != null && expiryTime < 1L) {
            throw new IllegalArgumentException("expiryTime");
        }
        this.accessToken = StringUtil.requireNotBlank(accessToken, "accessToken");
        this.refreshToken = refreshToken;
        this.expiryTime = expiryTime;
    }

    void copyFrom(ElyUser user) {
        Objects.requireNonNull(user, "user");
        if (!this.equals(user)) {
            throw new IllegalArgumentException("different users cannot be merged");
        }
        this.setUsername(user.getUsername());
        this.setDisplayName(user.getDisplayName());
        this.setUUID(user.getUUID());
        this.setToken(user.getAccessToken(), user.getRefreshToken(), user.getExpiryTime());
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected boolean equals(User user) {
        return user != null && ((ElyUser)user).id == this.id;
    }

    @Override
    protected ToStringBuilder toStringBuilder() {
        return super.toStringBuilder().append("uuid", (Object)this.uuid).append("expiryTime", (Object)this.expiryTime);
    }

    @Override
    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.uuid.hashCode();
        return result;
    }

    @Override
    public LoginCredentials getLoginCredentials() {
        return new LoginCredentials(this.username, this.accessToken, null, this.displayName, this.uuid, "mojang", this.displayName);
    }

    public static ElyUserJsonizer getJsonizer() {
        return new ElyUserJsonizer();
    }
}

