/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import java.util.Objects;
import java.util.UUID;
import ru.turikhay.tlauncher.user.ElyLegacyUserJsonizer;
import ru.turikhay.tlauncher.user.LoginCredentials;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.util.StringUtil;

public class ElyLegacyUser
extends User {
    public static final String TYPE = "ely_legacy";
    private final String username;
    private final UUID uuid;
    private String displayName;
    private String clientToken;
    private String accessToken;

    public ElyLegacyUser(String username, UUID uuid, String displayName, String clientToken, String accessToken) {
        this.username = StringUtil.requireNotBlank(username, "username");
        this.uuid = Objects.requireNonNull(uuid, "uuid");
        this.setDisplayName(displayName);
        this.setToken(clientToken, accessToken);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    void setDisplayName(String displayName) {
        this.displayName = StringUtil.requireNotBlank(displayName, "displayName");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected boolean equals(User user) {
        return this.username.equals(((ElyLegacyUser)user).username);
    }

    @Override
    public int hashCode() {
        int result = this.username.hashCode();
        result = 31 * result + this.uuid.hashCode();
        return result;
    }

    String getClientToken() {
        return this.clientToken;
    }

    String getAccessToken() {
        return this.accessToken;
    }

    void setToken(String clientToken, String accessToken) {
        this.clientToken = StringUtil.requireNotBlank(clientToken, "clientToken");
        this.accessToken = StringUtil.requireNotBlank(accessToken, "accessToken");
    }

    @Override
    public LoginCredentials getLoginCredentials() {
        return new LoginCredentials(this.username, this.accessToken, null, this.displayName, this.uuid, "mojang", this.displayName);
    }

    public static ElyLegacyUserJsonizer getJsonizer() {
        return new ElyLegacyUserJsonizer();
    }
}

