/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.launcher.Http;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.minecraft.auth.UUIDTypeAdapter;
import ru.turikhay.tlauncher.user.AuthBannedException;
import ru.turikhay.tlauncher.user.AuthDetailedException;
import ru.turikhay.tlauncher.user.AuthException;
import ru.turikhay.tlauncher.user.AuthUnavailableException;
import ru.turikhay.tlauncher.user.AuthUnknownException;
import ru.turikhay.tlauncher.user.ElyLegacyUser;
import ru.turikhay.tlauncher.user.InvalidCredentialsException;
import ru.turikhay.tlauncher.user.StandardAuth;
import ru.turikhay.util.StringUtil;
import ru.turikhay.util.U;

public final class ElyLegacyAuth
implements StandardAuth<ElyLegacyUser> {
    private static final String ELY_LEGACY_AUTHSERVER = "https://authserver.ely.by/auth/";

    @Override
    public ElyLegacyUser authorize(String username, String password) throws AuthException, IOException {
        AuthenticationResponse response = (AuthenticationResponse)new AuthenticationRequest(username, password, UUID.randomUUID().toString()).makeRequest();
        return new ElyLegacyUser(username, UUIDTypeAdapter.fromString(response.selectedProfile.id), response.selectedProfile.name, response.clientToken, response.accessToken);
    }

    @Override
    public void validate(ElyLegacyUser user) throws AuthException, IOException {
        RefreshResponse response = (RefreshResponse)new RefreshRequest(user.getClientToken(), user.getAccessToken()).makeRequest();
        user.setToken(response.clientToken, response.accessToken);
        user.setDisplayName(response.selectedProfile.name);
    }

    private static class AuthenticationRequest
    extends Request<AuthenticationResponse> {
        final Agent agent = new Agent();
        final String username;
        final String password;
        final String clientToken;

        AuthenticationRequest(String username, String password, String clientToken) {
            this.username = StringUtil.requireNotBlank(username, "username");
            this.password = StringUtil.requireNotBlank(password, "password");
            this.clientToken = StringUtil.requireNotBlank(clientToken, "clientToken");
        }

        @Override
        String url() {
            return "https://authserver.ely.by/auth/authenticate";
        }

        @Override
        Class<AuthenticationResponse> responseClass() {
            return AuthenticationResponse.class;
        }
    }

    private static abstract class Response
    implements Validable {
        String error;
        String errorMessage;
        String cause;

        private Response() {
        }

        @Override
        public void validate() throws Exception {
            if ("ForbiddenOperationException".equals(this.error)) {
                if ("Account protected with two factor auth.".equals(this.errorMessage)) {
                    throw new AuthException(this.errorMessage, "2fa", new Object[0]);
                }
                if ("This account has been suspended.".equals(this.errorMessage)) {
                    throw new AuthBannedException();
                }
                throw new InvalidCredentialsException(this.errorMessage);
            }
            if ("ServiceTemporarilyUnavailableException".equals(this.error)) {
                throw new AuthUnavailableException(this.errorMessage);
            }
            if (StringUtils.isNotBlank((CharSequence)this.error) || StringUtils.isNotBlank((CharSequence)this.errorMessage)) {
                throw new AuthDetailedException(this.errorMessage);
            }
        }
    }

    private static class AuthenticationResponse
    extends Response {
        String accessToken;
        String clientToken;
        GameProfile selectedProfile;

        private AuthenticationResponse() {
        }

        @Override
        public void validate() throws Exception {
            super.validate();
            StringUtil.requireNotBlank(this.accessToken, "accessToken");
            StringUtil.requireNotBlank(this.clientToken, "clientToken");
            Objects.requireNonNull(this.selectedProfile, "selectedProfile").validate();
        }
    }

    private static class GameProfile
    implements Validable {
        String id;
        String name;

        private GameProfile() {
        }

        @Override
        public void validate() {
            StringUtil.requireNotBlank(this.id, "id");
            StringUtil.requireNotBlank(this.name, "name");
        }
    }

    private static class RefreshRequest
    extends Request<RefreshResponse> {
        final String clientToken;
        final String accessToken;
        final boolean requestUser = true;

        RefreshRequest(String clientToken, String accessToken) {
            this.clientToken = StringUtil.requireNotBlank(clientToken, "clientToken");
            this.accessToken = StringUtil.requireNotBlank(accessToken, "accessToken");
        }

        @Override
        String url() {
            return "https://authserver.ely.by/auth/refresh";
        }

        @Override
        Class<RefreshResponse> responseClass() {
            return RefreshResponse.class;
        }
    }

    protected static class RefreshResponse
    extends Response {
        String accessToken;
        String clientToken;
        GameProfile selectedProfile;

        protected RefreshResponse() {
        }

        @Override
        public void validate() throws Exception {
            super.validate();
            StringUtil.requireNotBlank(this.accessToken, "accessToken");
            StringUtil.requireNotBlank(this.clientToken, "clientToken");
            Objects.requireNonNull(this.selectedProfile, "selectedProfile").validate();
        }
    }

    private static class Agent {
        final String name = "Minecraft";
        final int version = 1;

        private Agent() {
        }
    }

    private static abstract class Request<T extends Response> {
        private Request() {
        }

        abstract String url();

        abstract Class<T> responseClass();

        T makeRequest() throws AuthException, IOException {
            Response result;
            URL url = new URL(Objects.requireNonNull(this.url(), "url"));
            String input = U.getGson().toJson((Object)this);
            String jsonResult = Http.performPostRequest(url, input, "application/json");
            try {
                result = (Response)U.getGson().fromJson(jsonResult, this.responseClass());
                Objects.requireNonNull(result).validate();
            }
            catch (IOException | AuthException auth) {
                throw auth;
            }
            catch (Exception var7) {
                throw new AuthUnknownException(var7);
            }
            return (T)result;
        }
    }

    private static interface Validable {
        public void validate() throws Exception;
    }
}

