/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.user.ElyAuthCode;
import ru.turikhay.tlauncher.user.ElyAuthFlowListener;
import ru.turikhay.tlauncher.user.ElyAuthStrategyException;
import ru.turikhay.tlauncher.user.ElyFlowWaitTask;
import ru.turikhay.tlauncher.user.PrimaryElyAuthFlowBrowser;
import ru.turikhay.tlauncher.user.PrimaryElyAuthFlowDefaultBrowser;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.async.AsyncThread;

public abstract class ElyAuthFlow<L extends ElyAuthFlowListener>
implements Callable<ElyAuthCode> {
    private static final Logger LOGGER = LogManager.getLogger(ElyAuthFlow.class);
    static final String OAUTH2_BASE = "https://account.ely.by/oauth2/v1";
    static final String OAUTH2_AUTH_REQUEST = "https://account.ely.by/oauth2/v1?client_id=tlauncher&response_type=code&scope=account_info+minecraft_server_session&redirect_uri=%s&state=%d&prompt=select_account";
    private final List<L> listenerList = new ArrayList<L>();
    private final List<L> listenerList_ = Collections.unmodifiableList(this.listenerList);
    private final Object sync = new Object();
    private PrimaryElyAuthFlowBrowser browser = new PrimaryElyAuthFlowDefaultBrowser();
    private boolean started;

    ElyAuthFlow() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElyAuthCode call() throws Exception {
        ElyAuthCode code;
        Iterator<L> iterator = this.sync;
        synchronized (iterator) {
            this.started = true;
            for (ElyAuthFlowListener listener : this.listenerList) {
                listener.strategyStarted(this);
            }
        }
        try {
            code = Objects.requireNonNull(this.fetchCode(), "code");
            this.checkCancelled();
        }
        catch (InterruptedException interrupted) {
            this.onCancelled();
            for (ElyAuthFlowListener listener : this.listenerList) {
                listener.strategyCancelled(this);
            }
            throw interrupted;
        }
        catch (Exception e) {
            LOGGER.error("Error fetching code", (Throwable)e);
            for (ElyAuthFlowListener listener : this.listenerList) {
                listener.strategyErrored(this, e);
            }
            throw e;
        }
        for (ElyAuthFlowListener listener : this.listenerList) {
            listener.strategyComplete(this, code);
        }
        return code;
    }

    protected final void openBrowser(String redirect_uri, int state) throws InterruptedException {
        URL url;
        this.checkCancelled();
        try {
            url = new URL(String.format(Locale.ROOT, OAUTH2_AUTH_REQUEST, URLEncoder.encode(redirect_uri, FileUtil.getCharset().name()), state));
        }
        catch (Exception e) {
            throw new Error(e);
        }
        if (this.browser.openLink(url)) {
            for (ElyAuthFlowListener listener : this.getListenerList()) {
                listener.strategyUrlOpened(this, url);
            }
        } else {
            for (ElyAuthFlowListener listener : this.getListenerList()) {
                listener.strategyUrlOpeningFailed(this, url);
            }
        }
    }

    protected abstract ElyAuthCode fetchCode() throws ElyAuthStrategyException, InterruptedException;

    protected abstract void onCancelled();

    public void registerBrowser(PrimaryElyAuthFlowBrowser browser) {
        this.checkStarted();
        this.browser = Objects.requireNonNull(browser, "browser");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(L listener) {
        Objects.requireNonNull(listener, "listener");
        Object object = this.sync;
        synchronized (object) {
            this.checkStarted();
            this.listenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStarted() {
        Object object = this.sync;
        synchronized (object) {
            if (this.started) {
                throw new IllegalStateException("started");
            }
        }
    }

    protected void checkCancelled() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    protected final <V> V join(ElyFlowWaitTask<V> task) throws InterruptedException {
        if (task == null) {
            return null;
        }
        try {
            return AsyncThread.future(task).get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    protected final int generateState() {
        return new SecureRandom().nextInt();
    }

    protected final List<L> getListenerList() {
        return this.listenerList_;
    }
}

