/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.user.AuthDetailedException;
import ru.turikhay.tlauncher.user.AuthException;
import ru.turikhay.tlauncher.user.ElyUser;
import ru.turikhay.tlauncher.user.ElyUserJsonizer;
import ru.turikhay.util.FileUtil;
import ru.turikhay.util.StringUtil;
import ru.turikhay.util.U;
import ru.turikhay.util.git.MapTokenResolver;
import ru.turikhay.util.git.TokenReplacingReader;

public final class ElyAuthCode {
    private static final Logger LOGGER = LogManager.getLogger(ElyAuthCode.class);
    static final String API_BASE = "https://account.ely.by/api";
    static final String ACCOUNT_INFO = "https://account.ely.by/api/account/v1/info";
    static final String TOKEN_EXCHANGE = "https://account.ely.by/api/oauth2/v1/token";
    static final String TOKEN_EXCHANGE_REQUEST = "grant_type=authorization_code&client_id=${client_id}&client_secret=${client_secret}&code=${code}&state=${state}&redirect_uri=${redirect_uri}";
    final String code;
    final String redirect_uri;
    final int state;
    private final Gson gson;

    ElyAuthCode(String code, String redirect_uri, int state) {
        this.code = StringUtil.requireNotBlank(code, "code");
        this.redirect_uri = StringUtil.requireNotBlank(redirect_uri, "redirect_uri");
        this.state = state;
        this.gson = new GsonBuilder().create();
        LOGGER.info("Created with: code {}, redirect_uri {}, state {}", (Object)code, (Object)redirect_uri, (Object)state);
    }

    public ElyUser getUser() throws IOException, AuthException {
        CodeExchangePayload codeExchangePayload = this.exchangeCode();
        return this.getRawUser(codeExchangePayload).create();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("code", (Object)this.code).append("redirect_uri", (Object)this.redirect_uri).append("state", this.state).build();
    }

    CodeExchangePayload exchangeCode() throws IOException, AuthException {
        LOGGER.debug("Exchanging code...");
        CodeExchangePayload payload = this.readResponse(this.setupExchangeConnection(), CodeExchangePayload.class);
        LOGGER.debug("Checking payload consistency...");
        payload.checkConsistency();
        LOGGER.debug("Done");
        return payload;
    }

    ElyUserJsonizer.ElySerialize getRawUser(CodeExchangePayload payload) throws IOException, AuthException {
        LOGGER.debug("Getting user using payload...");
        ElyUserJsonizer.ElySerialize serialize = this.readResponse(this.setupInfoConnection(payload), ElyUserJsonizer.ElySerialize.class);
        serialize.accessToken = payload.access_token;
        serialize.refreshToken = payload.refresh_token;
        if (payload.expires_in != 0) {
            serialize.expiryTime = U.getUTC().getTimeInMillis() + (long)payload.expires_in * 1000L;
        } else {
            String[] jwtTokenParts = payload.access_token.split("\\.");
            if (jwtTokenParts.length != 3) {
                throw new IllegalArgumentException("Cannot determine token lifetime. The token is " + payload.access_token);
            }
            byte[] decoded = Base64.getUrlDecoder().decode(jwtTokenParts[1].getBytes(StandardCharsets.UTF_8));
            JWTPayload jwtPayload = this.parse(new ByteArrayInputStream(decoded), JWTPayload.class);
            if (jwtPayload.exp != 0) {
                serialize.expiryTime = (long)jwtPayload.exp * 1000L;
            }
        }
        LOGGER.debug("User: {}", (Object)this.gson.toJson((Object)serialize));
        return serialize;
    }

    <T> T readResponse(HttpURLConnection connection, Class<T> clazz) throws IOException, AuthException {
        byte[] read;
        IOException ioE = null;
        try (InputStream input = connection.getInputStream();){
            read = IOUtils.toByteArray((InputStream)input);
        }
        catch (IOException e) {
            ioE = e;
            try (InputStream error = connection.getErrorStream();){
                read = IOUtils.toByteArray((InputStream)error);
            }
            catch (IOException suppressedIoE) {
                ioE.addSuppressed(suppressedIoE);
                throw ioE;
            }
        }
        if (ioE != null) {
            throw this.detailed(read);
        }
        try {
            return this.parse(new ByteArrayInputStream(read), clazz);
        }
        catch (RuntimeException rE) {
            AuthDetailedException detailedException = this.detailed(read);
            detailedException.addSuppressed(rE);
            throw detailedException;
        }
    }

    <T> T parse(InputStream in, Class<T> clazz) {
        return (T)this.gson.fromJson((Reader)new InputStreamReader(in, FileUtil.getCharset()), clazz);
    }

    private AuthDetailedException detailed(byte[] data) {
        return new AuthDetailedException(new String(data, FileUtil.getCharset()));
    }

    HttpURLConnection setupExchangeConnection() throws IOException {
        LOGGER.debug("Setting up exchange connection...");
        String request = TokenReplacingReader.resolveVars(TOKEN_EXCHANGE_REQUEST, new MapTokenResolver((Map<String, String>)new HashMap<String, String>(){
            {
                this.put("client_id", "tlauncher");
                this.put("client_secret", "SbOVmJHBCjMV1NsewphGgA2SbyrVjN7IBcOte6b1HR7JGup2");
                this.put("code", ElyAuthCode.this.code);
                this.put("state", String.valueOf(ElyAuthCode.this.state));
                this.put("redirect_uri", ElyAuthCode.this.redirect_uri);
            }
        }));
        LOGGER.debug("Request: {}", (Object)request);
        HttpURLConnection connection = ElyAuthCode.setupConnection("POST", TOKEN_EXCHANGE);
        connection.setDoOutput(true);
        LOGGER.debug("Writing request...");
        IOUtils.write((String)request, (OutputStream)connection.getOutputStream(), (Charset)FileUtil.getCharset());
        LOGGER.debug("Done, reading response");
        return connection;
    }

    HttpURLConnection setupInfoConnection(CodeExchangePayload codePayload) throws IOException {
        HttpURLConnection connection = ElyAuthCode.setupConnection("GET", ACCOUNT_INFO);
        connection.setRequestProperty("Authorization", "Bearer " + codePayload.access_token);
        return connection;
    }

    static HttpURLConnection setupConnection(String method, String url) throws IOException {
        URL _url = new URL(url);
        HttpURLConnection urlConnection = (HttpURLConnection)_url.openConnection();
        urlConnection.setRequestMethod(method);
        urlConnection.setUseCaches(false);
        urlConnection.setReadTimeout(U.getReadTimeout());
        urlConnection.setConnectTimeout(U.getConnectionTimeout());
        return urlConnection;
    }

    private static class CodeExchangePayload {
        String access_token;
        String token_type;
        String refresh_token;
        int expires_in;

        private CodeExchangePayload() {
        }

        void checkConsistency() {
            StringUtil.requireNotBlank(this.access_token, "access_token");
            if (!"Bearer".equals(this.token_type)) {
                throw new IllegalArgumentException("token_type: " + this.token_type);
            }
            if (this.expires_in != 0 && this.expires_in < 0) {
                throw new IllegalArgumentException("expires_in: " + this.expires_in);
            }
        }
    }

    private static class JWTPayload {
        int iat;
        int exp;

        private JWTPayload() {
        }
    }
}

