/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.user.Auth;
import ru.turikhay.tlauncher.user.AuthException;
import ru.turikhay.tlauncher.user.AuthUnavailableException;
import ru.turikhay.tlauncher.user.ElyAuthCode;
import ru.turikhay.tlauncher.user.ElyAuthFlow;
import ru.turikhay.tlauncher.user.ElyUser;
import ru.turikhay.tlauncher.user.ElyUserValidator;
import ru.turikhay.tlauncher.user.FallbackElyAuthFlow;
import ru.turikhay.tlauncher.user.PrimaryElyAuthFlow;

public final class ElyAuth
implements Auth<ElyUser> {
    private static final Logger LOGGER = LogManager.getLogger(ElyAuth.class);
    static final String CLIENT_ID = "tlauncher";
    static final String CLIENT_SECRET = "SbOVmJHBCjMV1NsewphGgA2SbyrVjN7IBcOte6b1HR7JGup2";
    static final String ACCOUNT_BASE = "https://account.ely.by";
    static final String API_BASE = "https://account.ely.by/api";
    static final String TOKEN_EXCHANGE = "https://account.ely.by/api/oauth2/v1/token";

    public PrimaryElyAuthFlow getPrimaryFlow() {
        return new PrimaryElyAuthFlow();
    }

    public FallbackElyAuthFlow getFallbackFlow() {
        return new FallbackElyAuthFlow();
    }

    ElyUser createUser(ElyAuthFlow<?> flow) throws Exception {
        return this.fetchCodeImpl(flow).getUser();
    }

    private ElyAuthCode fetchCodeImpl(ElyAuthFlow<?> flow) throws Exception {
        Objects.requireNonNull(flow);
        LOGGER.debug("Trying to get code using {}", flow);
        try {
            return flow.call();
        }
        catch (InterruptedException interrupted) {
            throw interrupted;
        }
        catch (Exception e) {
            LOGGER.error("Couldn't fetch code", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void validate(ElyUser user) throws AuthException {
        Objects.requireNonNull(user, "user");
        ElyUserValidator validator = new ElyUserValidator(user);
        try {
            validator.validateUser();
        }
        catch (IOException e) {
            LOGGER.warn("Ely returned error", (Throwable)e);
            throw AuthException.soft(new AuthUnavailableException(e));
        }
    }
}

