/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.UserAuthentication;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import ru.turikhay.tlauncher.user.AuthlibAuth;
import ru.turikhay.tlauncher.user.AuthlibUser;
import ru.turikhay.tlauncher.user.UserJsonizer;

public abstract class AuthlibUserJsonizer<T extends AuthlibUser>
extends UserJsonizer<T> {
    private final AuthlibAuth<? extends AuthlibUser> auth;

    AuthlibUserJsonizer(AuthlibAuth<? extends AuthlibUser> auth) {
        this.auth = Objects.requireNonNull(auth, "auth");
    }

    protected Map<String, Object> createStorage(T src) {
        HashMap<String, Object> storage = new HashMap<String, Object>(((AuthlibUser)src).getMojangUserAuthentication().saveForStorage());
        storage.put("clientToken", ((AuthlibUser)src).getClientToken());
        storage.put("username", ((AuthlibUser)src).getUsername());
        return storage;
    }

    protected abstract T createFromUserAuthentication(UserAuthentication var1, JsonObject var2, JsonDeserializationContext var3);

    @Override
    public JsonObject serialize(T src, JsonSerializationContext context) {
        Map<String, Object> storage = this.createStorage(src);
        return (JsonObject)context.serialize(storage);
    }

    @Override
    public T deserialize(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        String clientToken = json.get("clientToken").getAsString();
        Map storage = (Map)context.deserialize((JsonElement)json, new TypeToken<Map<String, Object>>(){}.getType());
        Objects.requireNonNull(storage, "storage");
        if (storage.isEmpty()) {
            throw new IllegalArgumentException("storage is empty");
        }
        UserAuthentication userAuthentication = this.auth.createUserAuthentication(clientToken);
        userAuthentication.loadFromStorage(storage);
        return this.createFromUserAuthentication(userAuthentication, json, context);
    }
}

