/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.UserAuthentication;
import java.util.Objects;
import java.util.UUID;
import ru.turikhay.tlauncher.user.AuthlibUserPayload;
import ru.turikhay.tlauncher.user.LoginCredentials;
import ru.turikhay.tlauncher.user.User;
import ru.turikhay.util.StringUtil;

public abstract class AuthlibUser
extends User {
    private final String clientToken;
    private final String username;
    private final UserAuthentication userAuthentication;
    private static final Gson gson = new GsonBuilder().create();

    AuthlibUser(String clientToken, String username, UserAuthentication userAuthentication) {
        this.clientToken = StringUtil.requireNotBlank(clientToken, "clientToken");
        this.username = StringUtil.requireNotBlank(username, "username");
        this.userAuthentication = Objects.requireNonNull(userAuthentication, "userAuthentication");
        if (!userAuthentication.isLoggedIn()) {
            throw new IllegalArgumentException("userAuthentication can't log in");
        }
        Objects.requireNonNull(userAuthentication.getSelectedProfile(), "selectedProfile");
        Objects.requireNonNull(userAuthentication.getUserProperties(), "userProperties");
        Objects.requireNonNull(userAuthentication.getUserType(), "userType");
    }

    AuthlibUser(AuthlibUserPayload payload) {
        this(payload.getClientToken(), payload.getUsername(), payload.getAuthentication());
    }

    String getClientToken() {
        return this.clientToken;
    }

    @Override
    public UUID getUUID() {
        return this.getSelectedMojangProfile().getId();
    }

    UserAuthentication getMojangUserAuthentication() {
        return this.userAuthentication;
    }

    private GameProfile getSelectedMojangProfile() {
        return this.userAuthentication.getSelectedProfile();
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getDisplayName() {
        return this.getSelectedMojangProfile().getName();
    }

    @Override
    protected boolean equals(User user) {
        return user != null && this.getUsername().equals(user.getUsername());
    }

    @Override
    public int hashCode() {
        int result = this.username.hashCode();
        result = 31 * result + this.getType().hashCode();
        return result;
    }

    @Override
    public LoginCredentials getLoginCredentials() {
        return new LoginCredentials(this.username, this.userAuthentication.getAuthenticatedToken(), "{}", this.getDisplayName(), this.getSelectedMojangProfile().getId(), "mojang", this.getSelectedMojangProfile().getName());
    }
}

