/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.user;

import com.mojang.authlib.Agent;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.UserMigratedException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import ru.turikhay.tlauncher.user.Auth;
import ru.turikhay.tlauncher.user.AuthException;
import ru.turikhay.tlauncher.user.AuthUnknownException;
import ru.turikhay.tlauncher.user.AuthlibUser;
import ru.turikhay.tlauncher.user.AuthlibUserAttributes;
import ru.turikhay.tlauncher.user.InvalidCredentialsException;
import ru.turikhay.util.StringUtil;
import ru.turikhay.util.U;

public abstract class AuthlibAuth<T extends AuthlibUser>
implements Auth<T> {
    public UserAuthentication authorize(String clientToken, String username, String password) throws AuthException, IOException {
        StringUtil.requireNotBlank(clientToken, "clientToken");
        StringUtil.requireNotBlank(username, "username");
        StringUtil.requireNotBlank(password, "password");
        UserAuthentication userAuthentication = this.createUserAuthentication(clientToken);
        userAuthentication.setUsername(username);
        userAuthentication.setPassword(password);
        this.logIn(userAuthentication);
        if (userAuthentication.getSelectedProfile() == null) {
            throw new InvalidCredentialsException("no selected profile");
        }
        return userAuthentication;
    }

    public UserAuthentication authorizeWithToken(String clientToken, String uuid, String accessToken) throws AuthException, IOException {
        StringUtil.requireNotBlank(clientToken, "clientToken");
        StringUtil.requireNotBlank(uuid, "uuid");
        StringUtil.requireNotBlank(accessToken, "accessToken");
        UserAuthentication userAuthentication = this.createUserAuthentication(clientToken);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userid", uuid);
        map.put("accessToken", accessToken);
        userAuthentication.loadFromStorage(map);
        this.logIn(userAuthentication);
        if (userAuthentication.getSelectedProfile() == null) {
            throw new InvalidCredentialsException("no selected profile");
        }
        return userAuthentication;
    }

    @Override
    public void validate(T user) throws AuthException, IOException {
        this.logIn(((AuthlibUser)Objects.requireNonNull(user, "user")).getMojangUserAuthentication());
    }

    protected void logIn(UserAuthentication userAuthentication) throws AuthException, IOException {
        try {
            Objects.requireNonNull(userAuthentication, "user").logIn();
        }
        catch (UserMigratedException userMigrated) {
            throw new AuthException(userMigrated, "migrated", new Object[0]);
        }
        catch (com.mojang.authlib.exceptions.InvalidCredentialsException invalidCredentials) {
            throw new InvalidCredentialsException(invalidCredentials.getMessage());
        }
        catch (AuthenticationException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new AuthUnknownException(e);
        }
        AuthlibUserAttributes.validateUserAttributes(Objects.requireNonNull(userAuthentication.getAuthenticatedToken(), "accessToken"));
    }

    protected YggdrasilAuthenticationService createYggdrasilAuthenticationService(String clientToken) {
        return new YggdrasilAuthenticationService(U.getProxy(), StringUtil.requireNotBlank(clientToken));
    }

    protected UserAuthentication createUserAuthentication(String clientToken) {
        return this.createYggdrasilAuthenticationService(clientToken).createUserAuthentication(Agent.MINECRAFT);
    }

    protected static String randomClientToken() {
        return String.valueOf(UUID.randomUUID());
    }
}

