/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.versions;

import java.awt.Component;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import ru.turikhay.tlauncher.ui.center.CenterPanel;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableComponent;
import ru.turikhay.tlauncher.ui.swing.ResizeableComponent;
import ru.turikhay.tlauncher.ui.swing.extended.HTMLLabel;
import ru.turikhay.tlauncher.ui.versions.VersionHandler;
import ru.turikhay.util.OS;

public class VersionTipPanel
extends CenterPanel
implements LocalizableComponent,
ResizeableComponent {
    private final HTMLLabel tip = new HTMLLabel();

    VersionTipPanel(VersionHandler handler) {
        super(CenterPanel.tipTheme, CenterPanel.squareInsets);
        this.add((Component)this.tip);
        this.tip.addPropertyChangeListener("html", evt -> {
            Object o = evt.getNewValue();
            if (o instanceof View) {
                View view = (View)o;
                BasicHTML.getHTMLBaseline(view, 300 - this.getHorizontalInsets(), 0);
            }
        });
        this.updateLocale();
    }

    @Override
    public void updateLocale() {
        this.tip.setText("");
        String text = Localizable.get("version.list.tip");
        if (text != null) {
            text = text.replace("{Ctrl}", OS.OSX.isCurrent() ? "Command" : "Ctrl");
            this.tip.setText(text);
            this.onResize();
        }
    }

    @Override
    public void onResize() {
        this.setSize(300, this.tip.getHeight() + this.getVerticalInsets());
    }

    private int getVerticalInsets() {
        return this.getInsets().top + this.getInsets().bottom;
    }

    private int getHorizontalInsets() {
        return this.getInsets().left + this.getInsets().right;
    }
}

