/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.versions;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import net.minecraft.launcher.updater.LocalVersionList;
import net.minecraft.launcher.updater.VersionSyncInfo;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedButton;
import ru.turikhay.tlauncher.ui.versions.VersionHandler;
import ru.turikhay.tlauncher.ui.versions.VersionHandlerListener;
import ru.turikhay.tlauncher.ui.versions.VersionList;

public class VersionRemoveButton
extends ExtendedButton
implements VersionHandlerListener,
Blockable {
    private static final long serialVersionUID = 427368162418879141L;
    private static final String ILLEGAL_SELECTION_BLOCK = "illegal-selection";
    private static final String PREFIX = "version.manager.delete.";
    private static final String ERROR = "version.manager.delete.error.";
    private static final String ERROR_TITLE = "version.manager.delete.error.title";
    private static final String MENU = "version.manager.delete.menu.";
    private final VersionHandler handler;
    private final JPopupMenu menu;
    private boolean libraries;

    VersionRemoveButton(VersionList list) {
        this.setIcon(Images.getIcon24("remove"));
        this.handler = list.handler;
        this.handler.addListener(this);
        this.menu = new JPopupMenu();
        LocalizableMenuItem onlyJar = new LocalizableMenuItem("version.manager.delete.menu.jar");
        onlyJar.addActionListener(e -> this.onChosen(false));
        this.menu.add(onlyJar);
        LocalizableMenuItem withLibraries = new LocalizableMenuItem("version.manager.delete.menu.libraries");
        withLibraries.addActionListener(e -> this.onChosen(true));
        this.menu.add(withLibraries);
        this.addActionListener(e -> this.onPressed());
    }

    void onPressed() {
        this.menu.show(this, 0, this.getHeight());
    }

    void onChosen(boolean removeLibraries) {
        this.libraries = removeLibraries;
        this.handler.thread.deleteThread.iterate();
    }

    void delete() {
        if (this.handler.selected != null) {
            LocalVersionList localList = this.handler.vm.getLocalList();
            ArrayList<Throwable> errors = new ArrayList<Throwable>();
            for (VersionSyncInfo title : this.handler.selected) {
                if (!title.isInstalled()) continue;
                try {
                    localList.deleteVersion(title.getID(), this.libraries);
                }
                catch (Throwable var6) {
                    errors.add(var6);
                }
            }
            if (!errors.isEmpty()) {
                String title1 = Localizable.get(ERROR_TITLE);
                String message1 = Localizable.get(ERROR + (errors.size() == 1 ? "single" : "multiply"), errors);
                Alert.showError(title1, message1);
            }
        }
        this.handler.refresh();
    }

    @Override
    public void onVersionRefreshing(VersionManager vm) {
    }

    @Override
    public void onVersionRefreshed(VersionManager vm) {
    }

    @Override
    public void onVersionSelected(List<VersionSyncInfo> versions) {
        boolean onlyRemote = true;
        for (VersionSyncInfo version : versions) {
            if (!version.isInstalled()) continue;
            onlyRemote = false;
            break;
        }
        Blocker.setBlocked(this, ILLEGAL_SELECTION_BLOCK, onlyRemote);
    }

    @Override
    public void onVersionDeselected() {
        Blocker.block(this, ILLEGAL_SELECTION_BLOCK);
    }

    @Override
    public void onVersionDownload(List<VersionSyncInfo> list) {
    }

    @Override
    public void block(Object reason) {
        this.setEnabled(false);
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }
}

