/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.versions;

import java.util.List;
import javax.swing.JPopupMenu;
import net.minecraft.launcher.updater.VersionSyncInfo;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedButton;
import ru.turikhay.tlauncher.ui.versions.VersionHandler;
import ru.turikhay.tlauncher.ui.versions.VersionHandlerListener;
import ru.turikhay.tlauncher.ui.versions.VersionList;

public class VersionRefreshButton
extends ExtendedButton
implements VersionHandlerListener,
Blockable {
    private static final long serialVersionUID = -7148657244927244061L;
    private static final String PREFIX = "version.manager.refresher.";
    private static final String MENU = "version.manager.refresher.menu.";
    final VersionHandler handler;
    private final JPopupMenu menu;
    private ButtonState state;

    VersionRefreshButton(VersionList list) {
        this.handler = list.handler;
        this.menu = new JPopupMenu();
        LocalizableMenuItem local = new LocalizableMenuItem("version.manager.refresher.menu.local");
        local.addActionListener(e -> this.handler.refresh());
        this.menu.add(local);
        LocalizableMenuItem remote = new LocalizableMenuItem("version.manager.refresher.menu.remote");
        remote.addActionListener(e -> this.handler.asyncRefresh());
        this.menu.add(remote);
        this.addActionListener(e -> this.onPressed());
        this.setState(ButtonState.REFRESH);
        this.handler.addListener(this);
    }

    void onPressed() {
        switch (this.state) {
            case REFRESH: {
                this.menu.show(this, 0, this.getHeight());
                break;
            }
            case CANCEL: {
                this.handler.stopRefresh();
            }
        }
    }

    private void setState(ButtonState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        this.state = state;
        this.setIcon(Images.getIcon24(state.image));
    }

    @Override
    public void onVersionRefreshing(VersionManager vm) {
        this.setState(ButtonState.CANCEL);
    }

    @Override
    public void onVersionRefreshed(VersionManager vm) {
        this.setState(ButtonState.REFRESH);
    }

    @Override
    public void onVersionSelected(List<VersionSyncInfo> versions) {
    }

    @Override
    public void onVersionDeselected() {
    }

    @Override
    public void onVersionDownload(List<VersionSyncInfo> list) {
    }

    @Override
    public void block(Object reason) {
        if (!reason.equals("refresh")) {
            this.setEnabled(false);
        }
    }

    @Override
    public void unblock(Object reason) {
        this.setEnabled(true);
    }

    static enum ButtonState {
        REFRESH("refresh"),
        CANCEL("stop-circle-o");

        final String image;

        private ButtonState(String image) {
            this.image = image;
        }
    }
}

