/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.versions;

import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import net.minecraft.launcher.updater.VersionSyncInfo;
import ru.turikhay.tlauncher.ui.images.ImageIcon;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.swing.VersionCellRenderer;
import ru.turikhay.tlauncher.ui.versions.VersionHandler;
import ru.turikhay.tlauncher.ui.versions.VersionList;

public class VersionListCellRenderer
extends VersionCellRenderer {
    private final VersionHandler handler;
    private final ImageIcon downloading;

    VersionListCellRenderer(VersionList list) {
        this.handler = list.handler;
        this.downloading = Images.getIcon16("download");
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends VersionSyncInfo> list, VersionSyncInfo value, int index, boolean isSelected, boolean cellHasFocus) {
        List<VersionSyncInfo> downloadingInfo;
        if (value == null) {
            return null;
        }
        JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value.isInstalled() && !value.isUpToDate()) {
            label.setText(label.getText() + ' ' + Localizable.get("version.list.needsupdate"));
        }
        if ((downloadingInfo = this.handler.downloading) != null && downloadingInfo.size() > 0) {
            VersionSyncInfo compare = downloadingInfo.get(0);
            ImageIcon icon = compare.equals(value) ? this.downloading : null;
            label.setIcon(icon);
            label.setDisabledIcon(icon);
        }
        return label;
    }
}

