/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.versions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.JList;
import net.minecraft.launcher.updater.VersionSyncInfo;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.center.CenterPanel;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.LocalizableLabel;
import ru.turikhay.tlauncher.ui.swing.ScrollPane;
import ru.turikhay.tlauncher.ui.swing.SimpleListModel;
import ru.turikhay.tlauncher.ui.swing.VersionCellRenderer;
import ru.turikhay.tlauncher.ui.swing.extended.BorderPanel;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedButton;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.tlauncher.ui.versions.VersionDownloadButton;
import ru.turikhay.tlauncher.ui.versions.VersionHandler;
import ru.turikhay.tlauncher.ui.versions.VersionHandlerListener;
import ru.turikhay.tlauncher.ui.versions.VersionListCellRenderer;
import ru.turikhay.tlauncher.ui.versions.VersionRefreshButton;
import ru.turikhay.tlauncher.ui.versions.VersionRemoveButton;
import ru.turikhay.util.SwingUtil;

public class VersionList
extends CenterPanel
implements VersionHandlerListener {
    private static final long serialVersionUID = -7192156096621636270L;
    final VersionHandler handler;
    public final SimpleListModel<VersionSyncInfo> model;
    public final JList<VersionSyncInfo> list;
    final VersionDownloadButton download;
    final VersionRemoveButton remove;
    public final ExtendedButton refresh;
    public final ExtendedButton back;

    VersionList(VersionHandler h) {
        super(squareInsets);
        this.handler = h;
        BorderPanel panel = new BorderPanel(0, SwingUtil.magnify(5));
        LocalizableLabel label = new LocalizableLabel("version.manager.list");
        panel.setNorth(label);
        this.model = new SimpleListModel();
        this.list = new JList<VersionSyncInfo>(this.model);
        this.list.setCellRenderer(new VersionListCellRenderer(this));
        this.list.setSelectionMode(2);
        this.list.addListSelectionListener(e -> this.handler.onVersionSelected(this.list.getSelectedValuesList()));
        panel.setCenter(new ScrollPane(this.list, ScrollPane.ScrollBarPolicy.AS_NEEDED, ScrollPane.ScrollBarPolicy.NEVER));
        ExtendedPanel buttons = new ExtendedPanel(new GridLayout(0, 4));
        this.refresh = new VersionRefreshButton(this);
        buttons.add((Component)this.refresh);
        this.download = new VersionDownloadButton(this);
        buttons.add((Component)this.download);
        this.remove = new VersionRemoveButton(this);
        buttons.add((Component)this.remove);
        this.back = new ExtendedButton();
        this.back.setIcon(Images.getIcon24("home"));
        this.back.addActionListener(e -> this.handler.exitEditor());
        buttons.add((Component)this.back);
        panel.setSouth(buttons);
        this.add((Component)panel);
        this.handler.addListener(this);
        this.setSize(SwingUtil.magnify(new Dimension(300, 350)));
    }

    void select(List<VersionSyncInfo> list) {
        if (list != null) {
            int size = list.size();
            int[] indexes = new int[list.size()];
            for (int i = 0; i < size; ++i) {
                indexes[i] = this.model.indexOf(list.get(i));
            }
            this.list.setSelectedIndices(indexes);
        }
    }

    void deselect() {
        this.list.clearSelection();
    }

    void refreshFrom(VersionManager manager) {
        this.setRefresh(false);
        List<VersionSyncInfo> list = manager.getVersions(this.handler.filter, false);
        this.model.addAll(list);
    }

    void setRefresh(boolean refresh) {
        this.model.clear();
        if (refresh) {
            this.model.add(VersionCellRenderer.LOADING);
        }
    }

    @Override
    public void block(Object reason) {
        Blocker.blockComponents(reason, this.list, this.refresh, this.remove);
    }

    @Override
    public void unblock(Object reason) {
        Blocker.unblockComponents(reason, this.list, this.refresh, this.remove);
    }

    @Override
    public void onVersionRefreshing(VersionManager vm) {
        this.setRefresh(true);
    }

    @Override
    public void onVersionRefreshed(VersionManager vm) {
        this.refreshFrom(vm);
    }

    @Override
    public void onVersionSelected(List<VersionSyncInfo> version) {
    }

    @Override
    public void onVersionDeselected() {
    }

    @Override
    public void onVersionDownload(List<VersionSyncInfo> list) {
        this.select(list);
    }
}

