/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.versions;

import ru.turikhay.tlauncher.ui.block.Blocker;
import ru.turikhay.tlauncher.ui.versions.VersionDownloadButton;
import ru.turikhay.tlauncher.ui.versions.VersionHandler;
import ru.turikhay.tlauncher.ui.versions.VersionRemoveButton;
import ru.turikhay.util.U;
import ru.turikhay.util.async.LoopedThread;

public class VersionHandlerThread {
    public final String START_DOWNLOAD = "start-download";
    public final String STOP_DOWNLOAD = "stop-download";
    public final String DELETE_BLOCK = "deleting";
    private final VersionHandler handler;
    final StartDownloadThread startThread;
    final StopDownloadThread stopThread;
    final VersionDeleteThread deleteThread;

    VersionHandlerThread(VersionHandler handler) {
        this.handler = handler;
        this.startThread = new StartDownloadThread(this);
        this.stopThread = new StopDownloadThread(this);
        this.deleteThread = new VersionDeleteThread(this);
    }

    static class StartDownloadThread
    extends LoopedThread {
        private final VersionHandler handler;
        private final VersionDownloadButton button;

        StartDownloadThread(VersionHandlerThread parent) {
            super("StartDownloadThread");
            this.handler = parent.handler;
            this.button = this.handler.list.download;
            this.startAndWait();
        }

        @Override
        protected void iterateOnce() {
            this.button.setState(VersionDownloadButton.ButtonState.STOP);
            Blocker.block(this.handler, "start-download");
            this.button.startDownload();
            Blocker.unblock(this.handler, "start-download");
            this.button.setState(VersionDownloadButton.ButtonState.DOWNLOAD);
        }
    }

    static class StopDownloadThread
    extends LoopedThread {
        private final VersionHandler handler;
        private final VersionDownloadButton button;

        StopDownloadThread(VersionHandlerThread parent) {
            super("StopDownloadThread");
            this.handler = parent.handler;
            this.button = this.handler.list.download;
            this.startAndWait();
        }

        @Override
        protected void iterateOnce() {
            Blocker.block(this.button.blockable, "stop-download");
            while (!this.handler.downloader.isThreadLocked()) {
                U.sleepFor(1000L);
            }
            this.button.stopDownload();
        }
    }

    static class VersionDeleteThread
    extends LoopedThread {
        private final VersionHandler handler;
        private final VersionRemoveButton button;

        VersionDeleteThread(VersionHandlerThread parent) {
            super("VersionDeleteThread");
            this.handler = parent.handler;
            this.button = this.handler.list.remove;
            this.startAndWait();
        }

        @Override
        protected void iterateOnce() {
            Blocker.block(this.handler, "deleting");
            this.button.delete();
            Blocker.unblock(this.handler, "deleting");
        }
    }
}

