/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.versions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import net.minecraft.launcher.updater.VersionSyncInfo;
import ru.turikhay.tlauncher.TLauncher;
import ru.turikhay.tlauncher.downloader.AbortedDownloadException;
import ru.turikhay.tlauncher.downloader.DownloadableContainer;
import ru.turikhay.tlauncher.managers.VersionManager;
import ru.turikhay.tlauncher.managers.VersionSyncInfoContainer;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.tlauncher.ui.block.Blockable;
import ru.turikhay.tlauncher.ui.block.Unblockable;
import ru.turikhay.tlauncher.ui.images.Images;
import ru.turikhay.tlauncher.ui.loc.Localizable;
import ru.turikhay.tlauncher.ui.loc.LocalizableMenuItem;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedButton;
import ru.turikhay.tlauncher.ui.versions.VersionHandler;
import ru.turikhay.tlauncher.ui.versions.VersionHandlerListener;
import ru.turikhay.tlauncher.ui.versions.VersionList;

public class VersionDownloadButton
extends ExtendedButton
implements VersionHandlerListener,
Unblockable {
    private static final String SELECTION_BLOCK = "selection";
    private static final String PREFIX = "version.manager.downloader.";
    private static final String WARNING = "version.manager.downloader.warning.";
    private static final String WARNING_TITLE = "version.manager.downloader.warning.title";
    private static final String WARNING_FORCE = "version.manager.downloader.warning.force.";
    private static final String ERROR = "version.manager.downloader.error.";
    private static final String ERROR_TITLE = "version.manager.downloader.error.title";
    private static final String INFO = "version.manager.downloader.info.";
    private static final String INFO_TITLE = "version.manager.downloader.info.title";
    private static final String MENU = "version.manager.downloader.menu.";
    final VersionHandler handler;
    final Blockable blockable;
    private final JPopupMenu menu;
    private ButtonState state;
    private boolean downloading;
    private boolean aborted;
    boolean forceDownload;

    VersionDownloadButton(VersionList list) {
        this.handler = list.handler;
        this.blockable = new Blockable(){

            @Override
            public void block(Object reason) {
                VersionDownloadButton.this.setEnabled(false);
            }

            @Override
            public void unblock(Object reason) {
                VersionDownloadButton.this.setEnabled(true);
            }
        };
        this.menu = new JPopupMenu();
        LocalizableMenuItem ordinary = new LocalizableMenuItem("version.manager.downloader.menu.ordinary");
        ordinary.addActionListener(e -> {
            this.forceDownload = false;
            this.onDownloadCalled();
        });
        this.menu.add(ordinary);
        LocalizableMenuItem force = new LocalizableMenuItem("version.manager.downloader.menu.force");
        force.addActionListener(e -> {
            this.forceDownload = true;
            this.onDownloadCalled();
        });
        this.menu.add(force);
        this.addActionListener(e -> this.onPressed());
        this.setState(ButtonState.DOWNLOAD);
        this.handler.addListener(this);
    }

    void setState(ButtonState state) {
        if (state == null) {
            throw new NullPointerException();
        }
        this.state = state;
        this.setIcon(Images.getIcon24(state.image));
    }

    void onPressed() {
        switch (this.state) {
            case DOWNLOAD: {
                this.onDownloadPressed();
                break;
            }
            case STOP: {
                this.onStopCalled();
            }
        }
    }

    void onDownloadPressed() {
        this.menu.show(this, 0, this.getHeight());
    }

    void onDownloadCalled() {
        if (this.state != ButtonState.DOWNLOAD) {
            throw new IllegalStateException();
        }
        this.handler.thread.startThread.iterate();
    }

    void onStopCalled() {
        if (this.state != ButtonState.STOP) {
            throw new IllegalStateException();
        }
        this.handler.thread.stopThread.iterate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startDownload() {
        this.aborted = false;
        List<VersionSyncInfo> list = this.handler.getSelectedList();
        if (list != null && !list.isEmpty()) {
            int countLocal = 0;
            VersionSyncInfo local = null;
            for (VersionSyncInfo containers : list) {
                if (!this.forceDownload) continue;
                if (!containers.hasRemote()) {
                    Alert.showError(Localizable.get(ERROR_TITLE), Localizable.get("version.manager.downloader.error.local", containers.getID()));
                    return;
                }
                if (!containers.isUpToDate() || !containers.isInstalled()) continue;
                ++countLocal;
                local = containers;
            }
            if (countLocal > 0) {
                Object container;
                String var19;
                String var17 = Localizable.get(WARNING_TITLE);
                if (countLocal == 1) {
                    var19 = "single";
                    container = local.getID();
                } else {
                    var19 = "multiply";
                    container = countLocal;
                }
                if (!Alert.showQuestion(var17, Localizable.get(WARNING_FORCE + var19, container))) {
                    return;
                }
            }
            ArrayList<VersionSyncInfoContainer> var18 = new ArrayList<VersionSyncInfoContainer>();
            VersionManager var20 = TLauncher.getInstance().getVersionManager();
            try {
                this.downloading = true;
                for (VersionSyncInfo versionSyncInfo : list) {
                    VersionSyncInfoContainer errors;
                    block26: {
                        try {
                            versionSyncInfo.resolveCompleteVersion(var20, this.forceDownload);
                            errors = var20.downloadVersion(versionSyncInfo, null, this.forceDownload);
                            if (!this.aborted) break block26;
                            return;
                        }
                        catch (Exception var15) {
                            Alert.showError(Localizable.get(ERROR_TITLE), Localizable.get("version.manager.downloader.error.getting", versionSyncInfo.getID()), var15);
                            this.downloading = false;
                            return;
                        }
                    }
                    if (errors.getList().isEmpty()) continue;
                    var18.add(errors);
                }
                if (var18.isEmpty()) {
                    Alert.showMessage(Localizable.get(INFO_TITLE), Localizable.get("version.manager.downloader.info.no-needed"));
                    return;
                }
                if (var18.size() > 1) {
                    DownloadableContainer.removeDuplicates(var18);
                }
                if (this.aborted) {
                    return;
                }
                for (DownloadableContainer downloadableContainer : var18) {
                    this.handler.downloader.add(downloadableContainer);
                }
                this.handler.downloading = list;
                this.handler.onVersionDownload(list);
                this.handler.downloader.startDownloadAndWait();
            }
            finally {
                this.downloading = false;
            }
            this.handler.downloading.clear();
            for (VersionSyncInfoContainer versionSyncInfoContainer : var18) {
                List<Throwable> var24 = versionSyncInfoContainer.getErrors();
                VersionSyncInfo version = versionSyncInfoContainer.getVersion();
                if (var24.isEmpty()) {
                    try {
                        var20.getLocalList().saveVersion(version.getCompleteVersion(this.forceDownload));
                        continue;
                    }
                    catch (IOException var14) {
                        Alert.showError(Localizable.get(ERROR_TITLE), Localizable.get("version.manager.downloader.error.saving", version.getID()), var14);
                        return;
                    }
                }
                if (var24.get(0) instanceof AbortedDownloadException) continue;
                Alert.showError(Localizable.get(ERROR_TITLE), Localizable.get("version.manager.downloader.error.downloading", version.getID()), var24);
            }
            this.handler.refresh();
        }
    }

    void stopDownload() {
        this.aborted = true;
        if (this.downloading) {
            this.handler.downloader.stopDownloadAndWait();
        }
    }

    @Override
    public void onVersionRefreshing(VersionManager vm) {
    }

    @Override
    public void onVersionRefreshed(VersionManager vm) {
    }

    @Override
    public void onVersionSelected(List<VersionSyncInfo> versions) {
        if (!this.downloading) {
            this.blockable.unblock(SELECTION_BLOCK);
        }
    }

    @Override
    public void onVersionDeselected() {
        if (!this.downloading) {
            this.blockable.block(SELECTION_BLOCK);
        }
    }

    @Override
    public void onVersionDownload(List<VersionSyncInfo> list) {
    }

    public static enum ButtonState {
        DOWNLOAD("download"),
        STOP("stop-circle-o");

        final String image;

        private ButtonState(String image) {
            this.image = image;
        }
    }
}

