/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.theme;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.swing.JComponent;
import ru.turikhay.tlauncher.ui.theme.ExternalTheme;
import ru.turikhay.tlauncher.ui.theme.SystemTheme;
import ru.turikhay.util.StringUtil;

public abstract class Theme {
    private static Theme theme;

    public static Theme getTheme() {
        if (theme == null) {
            theme = SystemTheme.getSystemTheme();
        }
        return theme;
    }

    public static Theme loadTheme(String name, InputStream in) throws IOException {
        theme = new ExternalTheme(name, in);
        return theme;
    }

    public static void setup(JComponent comp) {
        Objects.requireNonNull(comp);
        comp.setForeground(Theme.getTheme().getForeground());
        comp.setBackground(Theme.getTheme().getBackground());
    }

    Theme(String name) {
        String name1 = StringUtil.requireNotBlank(name, "name");
    }

    public abstract Color getForeground();

    public abstract Color getSemiForeground();

    public abstract Color getBackground();

    public abstract Color getPanelBackground();

    public abstract Color getSuccess();

    public abstract Color getFailure();

    public abstract int getBorderSize();

    public abstract Color getBorder(Border var1);

    public abstract Color getShadow(Border var1);

    public abstract int getArc(Border var1);

    public abstract Color getIconColor(String var1);

    public abstract boolean useDarkTheme();

    public static enum Border {
        MAIN_PANEL,
        ADDITIONAL_PANEL,
        SETTINGS_PANEL;


        public int id() {
            return this.ordinal();
        }
    }
}

