/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.theme;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.UIManager;
import ru.turikhay.tlauncher.ui.theme.ColorfulIcons;
import ru.turikhay.tlauncher.ui.theme.Theme;
import ru.turikhay.util.OS;
import ru.turikhay.util.U;

public final class SystemTheme
extends Theme {
    static final int MAX_ARC = 64;
    static final int MAX_BORDER = 24;
    static final int BLACK_MIN = 64;
    static final int WHITE_MAX = 192;
    private static final SystemTheme instance = new SystemTheme();
    private final JLabel component;
    private final Map<Theme.Border, Color> borderColorMap;
    private final Color success = new Color(78, 196, 78);
    private final Color failure = new Color(179, 0, 0);
    private final Color shadow;
    private final Color semiForeground;
    private final Color panelBackground;

    public static SystemTheme getSystemTheme() {
        return instance;
    }

    private SystemTheme() {
        super("system");
        this.component = new JLabel();
        this.borderColorMap = new HashMap<Theme.Border, Color>();
        this.borderColorMap.put(Theme.Border.MAIN_PANEL, new Color(28, 128, 28, 255));
        this.borderColorMap.put(Theme.Border.ADDITIONAL_PANEL, new Color(255, 177, 177));
        this.borderColorMap.put(Theme.Border.SETTINGS_PANEL, OS.VERSION.startsWith("10.") ? new Color(217, 217, 217, 255) : new Color(172, 172, 172, 255));
        assert (this.borderColorMap.size() == Theme.Border.values().length);
        this.semiForeground = U.shiftColor(this.getForeground(), 96, 64, 192);
        this.panelBackground = U.shiftAlpha(this.getBackground(), -176, 64, 192);
        this.shadow = U.shiftAlpha(this.useDarkTheme() ? U.shiftColor(this.getForeground(), -96) : this.getBackground(), -150);
    }

    @Override
    public Color getForeground() {
        return this.component.getForeground();
    }

    @Override
    public Color getSemiForeground() {
        return this.semiForeground;
    }

    @Override
    public Color getBackground() {
        return this.component.getBackground();
    }

    @Override
    public Color getPanelBackground() {
        return this.panelBackground;
    }

    @Override
    public Color getSuccess() {
        return this.success;
    }

    @Override
    public Color getFailure() {
        return this.failure;
    }

    @Override
    public int getBorderSize() {
        return 2;
    }

    @Override
    public Color getBorder(Theme.Border border) {
        return this.borderColorMap.get((Object)Objects.requireNonNull(border, "border"));
    }

    @Override
    public Color getShadow(Theme.Border border) {
        return this.shadow;
    }

    @Override
    public int getArc(Theme.Border border) {
        return border == Theme.Border.SETTINGS_PANEL ? 16 : 24;
    }

    @Override
    public Color getIconColor(String iconName) {
        return this.useColorfulIcons() ? ColorfulIcons.getColor(iconName) : this.getForeground();
    }

    @Override
    public boolean useDarkTheme() {
        return !this.useColorfulIcons();
    }

    private boolean useColorfulIcons() {
        if (Boolean.getBoolean("tlauncher.ui.noColorfulIcons") || UIManager.getBoolean("laf.dark")) {
            return false;
        }
        Color background = this.getBackground();
        return background.getRed() > 64 || background.getGreen() > 64 || background.getBlue() > 64;
    }
}

