/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.theme;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.turikhay.tlauncher.exceptions.ParseException;
import ru.turikhay.tlauncher.ui.theme.ChildTheme;
import ru.turikhay.tlauncher.ui.theme.Theme;
import ru.turikhay.util.IntegerArray;

public final class ExternalTheme
extends ChildTheme {
    private static final Logger LOGGER = LogManager.getLogger(ExternalTheme.class);
    private final Properties properties = new Properties();

    ExternalTheme(String name, InputStream input) throws IOException {
        super(name);
        this.properties.load(Objects.requireNonNull(input, "input"));
    }

    private Color getColor(String key, Color defaultColor) {
        int[] a;
        Object obj = this.properties.get(key);
        if (obj == null) {
            return defaultColor;
        }
        if (obj instanceof Color) {
            return (Color)obj;
        }
        try {
            IntegerArray arr = IntegerArray.parseIntegerArray(String.valueOf(obj), '.');
            if (arr.size() < 3 || arr.size() > 4) {
                throw new ParseException("illegal size");
            }
            for (int i : a = arr.toArray()) {
                if (i >= 0 && i <= 255) continue;
                throw new ParseException("illegal byte:" + i);
            }
        }
        catch (RuntimeException rE) {
            LOGGER.warn("Could not parse color: {}", (Object)key, (Object)rE);
            this.properties.remove(key);
            return defaultColor;
        }
        Color color = a.length == 4 ? new Color(a[0], a[1], a[2], a[3]) : new Color(a[0], a[1], a[2], 255);
        this.properties.put(key, color);
        return color;
    }

    private int getSize(String key, int maxValue, int defValue) {
        int intVal;
        String value = this.properties.getProperty(key);
        if (value == null) {
            return defValue;
        }
        try {
            intVal = Integer.parseInt(value);
            if (intVal < 0 || intVal > maxValue) {
                throw new ParseException("illegal value [0, " + maxValue + "]: " + key);
            }
        }
        catch (RuntimeException rE) {
            LOGGER.warn("Could not parse integer at: {} = {}", (Object)key, (Object)value, (Object)rE);
            return defValue;
        }
        return intVal;
    }

    private boolean getBoolean(String key, boolean defaultValue) {
        String value = this.properties.getProperty(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    @Override
    public Color getForeground() {
        return this.getColor("foreground", super.getForeground());
    }

    @Override
    public Color getSemiForeground() {
        return this.getColor("semiforeground", super.getSemiForeground());
    }

    @Override
    public Color getBackground() {
        return this.getColor("background", super.getBackground());
    }

    @Override
    public Color getPanelBackground() {
        return this.getColor("panelbackground", super.getPanelBackground());
    }

    @Override
    public Color getSuccess() {
        return this.getColor("success", super.getSuccess());
    }

    @Override
    public Color getFailure() {
        return this.getColor("failure", super.getFailure());
    }

    @Override
    public int getBorderSize() {
        return this.getSize("border.size", 24, super.getBorderSize());
    }

    @Override
    public Color getBorder(Theme.Border border) {
        Color color = this.getColor("border." + Objects.requireNonNull(border, "border").name().toLowerCase(Locale.ROOT), null);
        if (color != null) {
            return color;
        }
        return this.getColor("border.color", super.getBorder(border));
    }

    @Override
    public Color getShadow(Theme.Border border) {
        Color color = this.getColor("shadow." + Objects.requireNonNull(border, "border").name().toLowerCase(Locale.ROOT), null);
        if (color != null) {
            return color;
        }
        String shadowValue = this.properties.getProperty("shadow");
        if ("border".equalsIgnoreCase(shadowValue)) {
            return this.getBorder(border);
        }
        return this.getColor("shadow", super.getShadow(border));
    }

    @Override
    public int getArc(Theme.Border border) {
        int size = this.getSize("arc." + Objects.requireNonNull(border, "border").name().toLowerCase(Locale.ROOT), 64, -1);
        if (size > -1) {
            return size;
        }
        return this.getSize("arc", 64, super.getArc(border));
    }

    @Override
    public Color getIconColor(String iconName) {
        return this.getColor("icon.color." + iconName, this.getColor("icon.defaultColor", super.getIconColor(iconName)));
    }

    @Override
    public boolean useDarkTheme() {
        return this.getBoolean("darkTheme.enabled", super.useDarkTheme());
    }
}

