/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.theme;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

class ColorfulIcons {
    private static final Color DEFAULT_COLOR = new Color(0x111111);
    private static final Color GREEN = new Color(52736);
    private static final Color EMERALD = new Color(52574);
    private static final Color DARKER_GREEN = new Color(39424);
    private static final Color RED = new Color(0xB40000);
    private static final Color YELLOW = new Color(16764160);
    private static final Color ORANGE = new Color(16751104);
    private static final Color DARKER_ORANGE = new Color(0xFF6600);
    private static final Color BLUE = new Color(4430591);
    private static final Map<String, Color> COLORS = new HashMap<String, Color>();

    ColorfulIcons() {
    }

    static Color getColor(String iconName) {
        return COLORS.getOrDefault(iconName, DEFAULT_COLOR);
    }

    private static void register(String iconName, Color color) {
        COLORS.put(iconName, color);
    }

    static {
        ColorfulIcons.register("bug", EMERALD);
        ColorfulIcons.register("check-square", GREEN);
        ColorfulIcons.register("comments-o", BLUE);
        ColorfulIcons.register("compress", BLUE);
        ColorfulIcons.register("download", GREEN);
        ColorfulIcons.register("envelope-open", BLUE);
        ColorfulIcons.register("folder-open", ORANGE);
        ColorfulIcons.register("home", DARKER_ORANGE);
        ColorfulIcons.register("info-circle", BLUE);
        ColorfulIcons.register("life-ring", BLUE);
        ColorfulIcons.register("lightbulb-o", ORANGE);
        ColorfulIcons.register("minus", RED);
        ColorfulIcons.register("pencil-square", BLUE);
        ColorfulIcons.register("play-circle-o-1", BLUE);
        ColorfulIcons.register("plus-square", GREEN);
        ColorfulIcons.register("refresh", DARKER_GREEN);
        ColorfulIcons.register("remove", RED);
        ColorfulIcons.register("stop-circle-o", RED);
        ColorfulIcons.register("warning", ORANGE);
        ColorfulIcons.register("warning-1", RED);
        ColorfulIcons.register("plug-1", ORANGE);
        ColorfulIcons.register("hourglass-start", ORANGE);
        ColorfulIcons.register("question", BLUE);
        ColorfulIcons.register("gift-1", DARKER_ORANGE);
    }
}

