/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing.extended;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedPanel;
import ru.turikhay.util.OS;
import ru.turikhay.util.SwingUtil;

public class VPanel
extends ExtendedPanel {
    private boolean magnify;
    private final Hashtable<Component, Gap> emptyPanelMap = new Hashtable();

    private VPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
        this.setMagnifyGaps(true);
        this.setLayout(new BoxLayout(this, 3));
    }

    public VPanel() {
        this(true);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (this.magnify) {
            super.addImpl(new Gap(comp), null, index);
        }
        this.checkMagnifyGaps();
    }

    @Override
    public void remove(int index) {
        boolean wasGap = this.getComponent(index) instanceof Gap;
        super.remove(index);
        if (wasGap) {
            this.checkMagnifyGaps();
        }
    }

    @Override
    public final BoxLayout getLayout() {
        return (BoxLayout)super.getLayout();
    }

    @Override
    public final void setLayout(LayoutManager mgr) {
        if (mgr instanceof BoxLayout) {
            int axis = ((BoxLayout)mgr).getAxis();
            if (axis != 3 && axis != 1) {
                throw new IllegalArgumentException("Illegal BoxLayout axis!");
            }
            super.setLayout(mgr);
        }
    }

    public final boolean getMagnifyGaps() {
        return this.magnify;
    }

    public final void setMagnifyGaps(boolean magnify) {
        this.magnify = !OS.WINDOWS.isCurrent() && TLauncherFrame.magnifyDimensions > 1.0 && magnify;
        this.checkMagnifyGaps();
    }

    protected final void checkMagnifyGaps() {
        HashMap<Component, Gap> searching = new HashMap<Component, Gap>(this.emptyPanelMap);
        if (this.magnify) {
            Iterator<Component> compI = searching.keySet().iterator();
            block0: while (compI.hasNext()) {
                Component compE = compI.next();
                for (Component comp : this.getComponents()) {
                    if (comp != compE) continue;
                    compI.remove();
                    continue block0;
                }
            }
        }
        for (Gap removal : searching.values()) {
            this.remove(removal);
        }
    }

    private class Gap
    extends JComponent {
        private final WeakReference<Component> comp;

        Gap(Component comp) {
            VPanel.this.emptyPanelMap.put(comp, this);
            this.comp = new WeakReference<Component>(comp);
            this.setOpaque(false);
            Dimension size = new Dimension(1, SwingUtil.magnify(2));
            this.setMinimumSize(size);
            this.setPreferredSize(size);
        }

        void check() {
            Component comp = (Component)this.comp.get();
            if (comp == null || comp.getParent() != VPanel.this) {
                VPanel.super.remove(this);
            }
        }
    }
}

