/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing.extended;

import ru.turikhay.tlauncher.ui.swing.util.IntegerArrayGetter;
import ru.turikhay.util.SwingUtil;
import ru.turikhay.util.U;
import ru.turikhay.util.async.LoopedThread;

public class QuickParameterListenerThread
extends LoopedThread {
    public static final int DEFAULT_TICK = 500;
    private final IntegerArrayGetter paramGetter;
    private final Runnable runnable;
    private final int tick;

    QuickParameterListenerThread(IntegerArrayGetter getter, Runnable run, int tick) {
        super("QuickParameterListenerThread");
        if (getter == null) {
            throw new NullPointerException("Getter is NULL!");
        }
        if (run == null) {
            throw new NullPointerException("Runnable is NULL!");
        }
        if (tick < 0) {
            throw new IllegalArgumentException("Tick must be positive!");
        }
        this.paramGetter = getter;
        this.runnable = run;
        this.tick = tick;
        this.setPriority(1);
        this.startAndWait();
    }

    QuickParameterListenerThread(IntegerArrayGetter getter, Runnable run) {
        this(getter, run, 500);
    }

    void startListening() {
        this.iterate();
    }

    @Override
    protected void iterateOnce() {
        boolean equal;
        int[] initial = SwingUtil.waitAndReturn(this.paramGetter::getIntegerArray);
        boolean i = false;
        do {
            this.sleep();
            int[] newvalue = SwingUtil.waitAndReturn(this.paramGetter::getIntegerArray);
            equal = true;
            for (int var5 = 0; var5 < initial.length; ++var5) {
                if (initial[var5] == newvalue[var5]) continue;
                equal = false;
                break;
            }
            initial = newvalue;
        } while (!equal);
        SwingUtil.wait(this.runnable::run);
    }

    private void sleep() {
        U.sleepFor(this.tick);
    }
}

