/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing.extended;

import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.ui.swing.extended.ExtendedLabel;
import ru.turikhay.util.SwingUtil;

public class HTMLLabel
extends ExtendedLabel {
    private String text;
    private int labelWidth;

    public HTMLLabel(String text, int labelWidth) {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                HTMLLabel.this.updateSize();
            }
        });
        this.setText(text, labelWidth);
    }

    public HTMLLabel(String text) {
        this(text, 0);
    }

    public HTMLLabel() {
        this((String)null);
    }

    public int getLabelWidth() {
        return this.labelWidth;
    }

    public void setLabelWidth(int width) {
        this.setText(this.text, width);
    }

    public void setText(String text, int labelWidth) {
        if (labelWidth < 0) {
            throw new IllegalArgumentException();
        }
        this.text = text;
        this.labelWidth = labelWidth;
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        if (this.getLabelWidth() > 0) {
            builder.append("<div width=\"").append(this.getLabelWidth()).append("\">");
        }
        if (text != null) {
            builder.append(StringUtils.replace((String)text, (String)"\n", (String)"<br/>"));
        }
        if (this.getLabelWidth() > 0) {
            builder.append("</div>");
        }
        builder.append("</html>");
        String rawText = builder.toString();
        this.setRawText(rawText);
    }

    public void updateSize() {
        if (this.getLabelWidth() > 0) {
            Dimension d = SwingUtil.getPrefSize(this, this.getLabelWidth(), 0);
            this.setMinimumSize(d);
            this.setPreferredSize(d);
        }
    }
}

