/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing.extended;

import javax.swing.JTextArea;
import javax.swing.text.Document;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;

public class ExtendedTextArea
extends JTextArea {
    public ExtendedTextArea(Document doc, String text, int rows, int columns) {
        super(null, text, rows, columns);
    }

    public ExtendedTextArea() {
        this(null, null, 0, 0);
    }

    @Override
    protected Document createDefaultModel() {
        return new ContentDocument();
    }

    public static class ContentDocument
    extends PlainDocument {
        public ContentDocument() {
            super(new SequenceGapContent());
        }

        public SequenceGapContent accessContent() {
            return (SequenceGapContent)this.getContent();
        }
    }

    public static class SequenceGapContent
    extends GapContent
    implements CharSequence {
        private int checkIndex(int index, String s) {
            if (index < 0) {
                throw new IndexOutOfBoundsException(s + " is too small: " + index);
            }
            if (index >= this.length()) {
                throw new IndexOutOfBoundsException(s + " equals or above length: " + index + " (" + this.length() + ")");
            }
            return index;
        }

        @Override
        public char charAt(int index) {
            return ((char[])this.getArray())[this.checkIndex(index, "index")];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new SubSequence(start, end);
        }

        public class SubSequence
        implements CharSequence {
            private final int start;
            private final int end;

            SubSequence(int start, int end) {
                this.start = SequenceGapContent.this.checkIndex(start, "start");
                this.end = SequenceGapContent.this.checkIndex(end, "end");
            }

            @Override
            public int length() {
                return this.end - this.start + 1;
            }

            @Override
            public char charAt(int index) {
                return SequenceGapContent.this.charAt(this.start + index);
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                return new SubSequence(this.start + start, this.start + end);
            }
        }
    }
}

