/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing.extended;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import ru.turikhay.tlauncher.ui.swing.extended.QuickParameterListenerThread;

public abstract class ExtendedComponentListener
implements ComponentListener {
    private final Component comp;
    private final QuickParameterListenerThread resizeListener;
    private final QuickParameterListenerThread moveListener;
    private ComponentEvent lastResizeEvent;
    private ComponentEvent lastMoveEvent;

    public ExtendedComponentListener(Component component, int tick) {
        if (component == null) {
            throw new NullPointerException();
        }
        this.comp = component;
        this.resizeListener = new QuickParameterListenerThread(() -> new int[]{this.comp.getWidth(), this.comp.getHeight()}, () -> this.onComponentResized(this.lastResizeEvent), tick);
        this.moveListener = new QuickParameterListenerThread(() -> {
            Point location = this.comp.getLocation();
            return new int[]{location.x, location.y};
        }, () -> this.onComponentMoved(this.lastMoveEvent), tick);
    }

    public ExtendedComponentListener(Component component) {
        this(component, 500);
    }

    @Override
    public final void componentResized(ComponentEvent e) {
        this.onComponentResizing(e);
        this.resizeListener.startListening();
    }

    @Override
    public final void componentMoved(ComponentEvent e) {
        this.onComponentMoving(e);
        this.moveListener.startListening();
    }

    public boolean isListening() {
        return this.resizeListener.isIterating() || this.moveListener.isIterating();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void onComponentResizing(ComponentEvent e) {
    }

    public void onComponentResized(ComponentEvent e) {
    }

    public void onComponentMoving(ComponentEvent e) {
    }

    public void onComponentMoved(ComponentEvent e) {
    }

    public void dispose() {
        this.moveListener.dispose();
        this.resizeListener.dispose();
    }
}

