/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing.extended;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import ru.turikhay.tlauncher.ui.TLauncherFrame;
import ru.turikhay.tlauncher.ui.converter.StringConverter;
import ru.turikhay.tlauncher.ui.swing.DefaultConverterCellRenderer;
import ru.turikhay.tlauncher.ui.swing.SimpleComboBoxModel;
import ru.turikhay.tlauncher.ui.theme.Theme;

public class ExtendedComboBox<T>
extends JComboBox<T> {
    private static final long serialVersionUID = -4509947341182373649L;
    private StringConverter<T> converter;

    public ExtendedComboBox(ListCellRenderer<T> renderer) {
        Theme.setup(this);
        this.setModel(new SimpleComboBoxModel());
        this.setRenderer(renderer);
        this.setOpaque(false);
        this.setFont(this.getFont().deriveFont(TLauncherFrame.getFontSize()));
        ((JComponent)this.getEditor().getEditorComponent()).setOpaque(false);
    }

    public ExtendedComboBox(StringConverter<T> converter) {
        this(new DefaultConverterCellRenderer<T>(converter));
        this.converter = converter;
    }

    public ExtendedComboBox() {
        this((ListCellRenderer)null);
    }

    public SimpleComboBoxModel<T> getSimpleModel() {
        return (SimpleComboBoxModel)this.getModel();
    }

    public T getSelectedValue() {
        return (T)this.getSelectedItem();
    }

    public void setSelectedValue(T value) {
        this.setSelectedItem(value);
    }

    public void setSelectedValue(String string) {
        T value = this.convert(string);
        if (value != null) {
            this.setSelectedValue(value);
        }
    }

    public StringConverter<T> getConverter() {
        return this.converter;
    }

    public void setConverter(StringConverter<T> converter) {
        this.converter = converter;
    }

    protected String convert(T obj) {
        return this.converter != null ? this.converter.toValue(obj) : (obj == null ? null : obj.toString());
    }

    protected T convert(String from) {
        return this.converter == null ? null : (T)this.converter.fromString(from);
    }
}

