/*
 * Decompiled with CFR 0.152.
 */
package ru.turikhay.tlauncher.ui.swing.editor;

import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.commons.lang3.StringUtils;
import ru.turikhay.tlauncher.ui.alert.Alert;
import ru.turikhay.util.OS;

public abstract class HyperlinkProcessor {
    public static final HyperlinkProcessor defaultProcessor = new HyperlinkProcessor(){
        private JPopupMenu popup;

        @Override
        public JPopupMenu process(String link) {
            URI uri;
            if (link == null) {
                return null;
            }
            if (link.startsWith("[") && link.endsWith("]")) {
                if (this.popup == null) {
                    this.popup = new JPopupMenu();
                } else {
                    this.popup.removeAll();
                }
                String[] links = StringUtils.split((String)link.substring(1, link.length() - 1), (char)';');
                if (links.length == 0) {
                    return null;
                }
                this.popup.add(this.newItem(links[0], "<html><b>" + links[0] + "</b></html>"));
                this.popup.addSeparator();
                for (int i = 1; i < links.length; ++i) {
                    this.popup.add(this.newItem(links[i]));
                }
                return this.popup;
            }
            try {
                uri = new URI(link);
                uri.toURL();
            }
            catch (Exception var6) {
                try {
                    uri = new URI("http://" + link);
                }
                catch (URISyntaxException var5) {
                    Alert.showLocError("browser.hyperlink.create.error", var6);
                    return null;
                }
            }
            OS.openLink(uri);
            return null;
        }

        private JMenuItem newItem(String link) {
            return this.newItem(link, null);
        }

        private JMenuItem newItem(String link, String name) {
            URI _uri;
            if (name == null) {
                name = link.length() > 30 ? link.substring(0, 30) + "..." : link;
            }
            JMenuItem item = new JMenuItem(name);
            try {
                _uri = new URI(link);
                _uri.toURL();
            }
            catch (Exception var6) {
                try {
                    _uri = new URI("http://" + link);
                }
                catch (URISyntaxException var5) {
                    _uri = null;
                }
            }
            URI uri = _uri;
            item.addActionListener(e -> {
                if (uri == null) {
                    Alert.showLocError("browser.hyperlink.create.error");
                }
                OS.openLink(uri);
            });
            return item;
        }
    };

    public abstract JPopupMenu process(String var1);
}

